/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix;

import com.alibaba.druid.util.StringUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.matrix.RulesSet;
import org.n3r.eql.matrix.impl.MatrixFunction;
import org.n3r.eql.matrix.impl.MatrixMapper;
import org.n3r.eql.matrix.impl.MatrixRule;
import org.n3r.eql.matrix.impl.MatrixTableField;
import org.n3r.eql.util.C;
import org.n3r.eql.util.S;

public class RuleParser {
    static Pattern ruleIndexPattern = Pattern.compile("rule\\s*\\(\\s*(\\d+)\\s*\\)");
    static Pattern javaIdentifierPattern = Pattern.compile("([_\\w][_\\w\\d]*)\\s*\\((.*?)\\)");
    static Pattern aliasPattern = Pattern.compile("[_\\w]([_\\w\\d])*");

    public RulesSet parse(String ruleSpec) {
        Iterable lines = Splitter.on((char)'\n').trimResults().split((CharSequence)ruleSpec);
        RulesSet rulesSet = new RulesSet();
        int lineNo = 0;
        for (String line : lines) {
            ++lineNo;
            if (StringUtils.isEmpty((String)line) || line.startsWith("#")) continue;
            try {
                if (line.startsWith("alias")) {
                    this.parseAlias(rulesSet, line);
                    continue;
                }
                if (line.startsWith("rule")) {
                    this.parseRule(rulesSet, line);
                    continue;
                }
                throw new RuntimeException("unknown format");
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(ex.getMessage() + " in line " + lineNo + " [" + line + "]");
            }
        }
        return rulesSet;
    }

    private void parseRule(RulesSet rulesSet, String line) {
        MatrixRule matrixRule = new MatrixRule();
        String remain = S.trimToEmpty(line);
        remain = this.parseRuleNo(rulesSet, matrixRule, remain);
        remain = this.parseFunction(rulesSet, matrixRule, remain);
        this.parseMapper(rulesSet, matrixRule, remain);
        rulesSet.addRule(matrixRule);
    }

    private void parseMapper(RulesSet rulesSet, MatrixRule matrixRule, String remain) {
        if (StringUtils.isEmpty((String)remain)) {
            throw new RuntimeException("rule is invalid without mapper");
        }
        Matcher matcher = javaIdentifierPattern.matcher(remain);
        boolean found = matcher.find();
        if (!found || matcher.start() != 0) {
            throw new RuntimeException("mappers invalid ");
        }
        String mapperAlias = matcher.group(1);
        Class<? extends MatrixMapper> mapClass = rulesSet.getMapAlias(mapperAlias);
        if (mapClass == null) {
            throw new RuntimeException("mapper is unknown ");
        }
        MatrixMapper mapper = this.createMatrixMapper(mapClass);
        String mapperParamsStr = S.trimToEmpty(matcher.group(2));
        if (S.isBlank(mapperParamsStr)) {
            throw new RuntimeException("mapper is invalid ");
        }
        List mapperParams = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)mapperParamsStr);
        mapper.config(mapperParams);
        matrixRule.mapper = mapper;
    }

    private String parseFunction(RulesSet rulesSet, MatrixRule matrixRule, String remain) {
        if (StringUtils.isEmpty((String)remain)) {
            throw new RuntimeException("rule is invalid");
        }
        Matcher matcher = javaIdentifierPattern.matcher(remain);
        boolean found = matcher.find();
        if (!found || matcher.start() != 0) {
            throw new RuntimeException("function is invalid");
        }
        String funcAlias = matcher.group(1);
        Class<? extends MatrixFunction> funcClass = rulesSet.getFunctionAlias(funcAlias);
        if (funcClass == null) {
            throw new RuntimeException("function is unknown");
        }
        String funcParams = S.trimToEmpty(matcher.group(2));
        if (S.isBlank(funcParams)) {
            throw new RuntimeException("function should have parameters");
        }
        MatrixFunction func = this.createMatrixFunction(funcClass);
        List params = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)funcParams);
        ArrayList fields = Lists.newArrayList();
        ArrayList realFuncParams = Lists.newArrayList();
        int ii = params.size();
        for (int i = this.parseFunctionRelativeTableFields(func, params, fields); i < ii; ++i) {
            realFuncParams.add(params.get(i));
        }
        func.configFunctionParameters(realFuncParams.toArray(new String[0]));
        matrixRule.function = func;
        return S.trimToEmpty(remain.substring(matcher.end()));
    }

    private int parseFunctionRelativeTableFields(MatrixFunction func, List<String> params, List<MatrixTableField> fields) {
        String param;
        int i;
        int ii = params.size();
        for (i = 0; i < ii && (param = params.get(i)).startsWith("."); ++i) {
            int dotPos = param.indexOf(46, 1);
            if (dotPos <= 0 || dotPos == param.length() - 1) {
                throw new RuntimeException("rule function should have at least one relative table field");
            }
            String tableName = param.substring(1, dotPos);
            String fieldName = param.substring(dotPos + 1);
            if (!aliasPattern.matcher(tableName).matches()) {
                throw new RuntimeException("table name is invalid int rule function parameters");
            }
            if (!aliasPattern.matcher(fieldName).matches()) {
                throw new RuntimeException("field name is invalid int rule function parameters");
            }
            fields.add(new MatrixTableField(tableName, fieldName));
        }
        func.configRelativeTableFields(fields.toArray(new MatrixTableField[0]));
        return i;
    }

    private String parseRuleNo(RulesSet rulesSet, MatrixRule matrixRule, String remain) {
        Matcher matcher = ruleIndexPattern.matcher(remain);
        boolean found = matcher.find();
        if (!found || matcher.start() != 0) {
            throw new RuntimeException("rule is invalid");
        }
        int ruleNo = Integer.parseInt(matcher.group(1));
        MatrixRule rule = rulesSet.getRule(ruleNo);
        if (rule != null) {
            throw new RuntimeException("rule no is duplicated");
        }
        matrixRule.ruleNo = ruleNo;
        return S.trimToEmpty(remain.substring(matcher.end()));
    }

    private MatrixMapper createMatrixMapper(Class<? extends MatrixMapper> mapClass) {
        try {
            return mapClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MatrixFunction createMatrixFunction(Class<? extends MatrixFunction> funcClass) {
        try {
            return funcClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseAlias(RulesSet rulesSet, String line) {
        String map = line.substring("alias".length());
        String alias = S.trimToEmpty(map);
        if (StringUtils.isEmpty((String)alias) || !alias.startsWith("(") || !alias.endsWith(")")) {
            throw new RuntimeException("alias required format: alias(shortName, FQCN)");
        }
        if (StringUtils.isEmpty((String)(alias = S.trimToEmpty(alias.substring(1, alias.length() - 1))))) {
            throw new RuntimeException("alias required format: alias(shortName, FQCN)");
        }
        int commaPos = alias.indexOf(44);
        if (commaPos <= 0 || commaPos == alias.length() - 1) {
            throw new RuntimeException("alias required format: alias(shortName, FQCN)");
        }
        String aliasName = S.trimToEmpty(alias.substring(0, commaPos));
        String fullName = S.trimToEmpty(alias.substring(commaPos + 1));
        if (!aliasPattern.matcher(aliasName).matches()) {
            throw new RuntimeException("alias short name is invalid");
        }
        Class<? extends MatrixFunction> fullClass = this.getFullClass(fullName);
        if (fullClass == null) {
            throw new RuntimeException("alias full name is invalid");
        }
        rulesSet.addAlias(aliasName, fullClass);
    }

    private Class<? extends MatrixFunction> getFullClass(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return null;
        }
        try {
            return Class.forName(fullName, false, C.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

