/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix.sqlparser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import org.n3r.diamond.client.DiamondMiner;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.matrix.RuleParser;
import org.n3r.eql.matrix.RulesSet;
import org.n3r.eql.matrix.sqlparser.DefaultMatrixSqlParseResult;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParseNoResult;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParseResult;
import org.n3r.eql.matrix.sqlparser.MysqlInsertVisitor;
import org.n3r.eql.matrix.sqlparser.MysqlMatrixVisitor;
import org.n3r.eql.matrix.sqlparser.MysqlSelectVisitor;
import org.n3r.eql.matrix.sqlparser.MysqlUpdateVisitor;
import org.n3r.eql.util.S;

public class MatrixSqlParser {
    public MatrixSqlParseResult parse(EqlConfig eqlConfig, String sql) {
        String rulesContent = this.readRules(eqlConfig);
        RulesSet ruleSet = new RuleParser().parse(rulesContent);
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        List stmtList = parser.parseStatementList();
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        MysqlMatrixVisitor visitor = null;
        if (stmt instanceof SQLInsertStatement) {
            visitor = new MysqlInsertVisitor();
        } else if (stmt instanceof SQLSelectStatement) {
            visitor = new MysqlSelectVisitor();
        } else if (stmt instanceof SQLUpdateStatement) {
            visitor = new MysqlUpdateVisitor();
        }
        if (visitor != null) {
            visitor.ruleSet = ruleSet;
            stmt.accept((SQLASTVisitor)visitor);
            if (visitor.sqlFieldIndexes.length > 0) {
                return new DefaultMatrixSqlParseResult(ruleSet, visitor.sqlFieldIndexes);
            }
        }
        return MatrixSqlParseNoResult.instance;
    }

    private String readRules(EqlConfig eqlConfig) {
        String rules = eqlConfig.getStr("rules");
        if (!rules.startsWith("diamond:")) {
            return rules;
        }
        String groupDataId = rules.substring("diamond:".length());
        int commaPos = groupDataId.indexOf(44);
        String group = S.trimToEmpty(groupDataId.substring(0, commaPos));
        String dataId = S.trimToEmpty(groupDataId.substring(commaPos + 1));
        return DiamondMiner.getStone((String)group, (String)dataId);
    }
}

