/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.ex.EqlConfigException;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.EqlParamsParserResult;
import org.n3r.eql.param.EqlUniqueSqlTemplate;
import org.n3r.eql.param.PlaceholderType;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.S;

public class EqlParamsParser {
    private static Pattern PARAM_PATTERN = Pattern.compile("#(.*?)#");
    static LoadingCache<EqlUniqueSqlTemplate, EqlParamsParserResult> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<EqlUniqueSqlTemplate, EqlParamsParserResult>(){

        public EqlParamsParserResult load(EqlUniqueSqlTemplate eqlUniqueSqlTemplate) throws Exception {
            EqlParamsParserResult result = new EqlParamsParserResult();
            new EqlParamsParser(result, eqlUniqueSqlTemplate).parseParams();
            return result;
        }
    });
    private final EqlParamsParserResult result;
    private final EqlUniqueSqlId eqlUniqueSqlId;
    private final String templateSql;
    private static final Pattern lastWord = Pattern.compile(".*\\b([\\w_\\d]+)\\b.*$", 32);
    private static final Pattern questionPattern = Pattern.compile("#\\s*\\?\\s*(:.*)?\\s*#");

    public static void parseParams(EqlRun eqlRun, String sqlStr) {
        EqlBlock eqlBlock = eqlRun.getEqlBlock();
        EqlUniqueSqlId uniqueSqlId = eqlBlock != null ? eqlBlock.getUniqueSqlId() : null;
        EqlUniqueSqlTemplate sqlTemplate = new EqlUniqueSqlTemplate(uniqueSqlId, sqlStr);
        EqlParamsParserResult result = (EqlParamsParserResult)cache.getUnchecked((Object)sqlTemplate);
        eqlRun.setSqlType(result.getSqlType());
        eqlRun.setRunSql(result.getRunSql());
        eqlRun.setPlaceholderNum(result.getPlaceholderNum());
        eqlRun.setPlaceHolderType(result.getPlaceHolderType());
        eqlRun.setPlaceHolderOutType(result.getPlaceHolderOutType());
        eqlRun.setPlaceHolders(result.getPlaceHolders());
    }

    public EqlParamsParser(EqlParamsParserResult result, EqlUniqueSqlTemplate eqlUniqueSqlTemplate) {
        this.result = result;
        this.eqlUniqueSqlId = eqlUniqueSqlTemplate.getEqlUniqueSqlId();
        this.templateSql = eqlUniqueSqlTemplate.getTemplateSql();
    }

    private void parseParams() {
        EqlType eqlType = EqlType.parseSqlType(this.templateSql);
        this.result.setSqlType(eqlType);
        Matcher matcher = PARAM_PATTERN.matcher(this.templateSql);
        ArrayList<String> placeHolders = new ArrayList<String>();
        ArrayList<String> placeHolderOptions = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        int startPos = 0;
        boolean hasEscape = false;
        while (matcher.find(startPos)) {
            if (this.hasPrevEscape(matcher.start())) {
                sql.append(this.templateSql.substring(startPos, matcher.start() + 1));
                startPos = matcher.start() + 1;
                hasEscape = true;
                continue;
            }
            String placeHolder = matcher.group(1).trim();
            String paramOptions = "";
            int colonPos = placeHolder.indexOf(58);
            if (colonPos >= 0) {
                paramOptions = placeHolder.substring(colonPos + 1).trim();
                placeHolder = placeHolder.substring(0, colonPos).trim();
            }
            if ("?".equals(placeHolder)) {
                placeHolder = this.inferVarName(eqlType, this.templateSql, startPos, matcher.start());
            }
            placeHolders.add(placeHolder);
            placeHolderOptions.add(paramOptions);
            sql.append(this.templateSql.substring(startPos, matcher.start())).append('?');
            startPos = matcher.end();
        }
        sql.append(this.templateSql.substring(startPos));
        String onelineSql = sql.toString();
        this.result.setRunSql(hasEscape ? this.unescape(onelineSql) : onelineSql);
        this.result.setPlaceholderNum(placeHolders.size());
        this.parsePlaceholders(placeHolders, placeHolderOptions);
    }

    private String unescape(String sql) {
        StringBuilder unescape = new StringBuilder(sql.length());
        int lastPos = 0;
        int pos = sql.indexOf(92, lastPos);
        while (pos >= 0 && lastPos < sql.length()) {
            unescape.append(sql.substring(lastPos, pos)).append(sql.charAt(pos + 1));
            lastPos = pos + 2;
            if (lastPos >= sql.length()) continue;
            pos = sql.indexOf(92, lastPos);
        }
        if (lastPos < sql.length()) {
            unescape.append(sql.substring(lastPos));
        }
        return unescape.toString();
    }

    private boolean hasPrevEscape(int start) {
        if (start == 0) {
            return false;
        }
        boolean hasPreEscape = false;
        for (int i = start - 1; i >= 0 && this.templateSql.charAt(i) == '\\'; --i) {
            hasPreEscape = !hasPreEscape;
        }
        return hasPreEscape;
    }

    private String inferVarName(EqlType sqlType, String rawSql, int startPos, int endPos) {
        String variableName = null;
        switch (sqlType) {
            case SELECT: 
            case UPDATE: {
                variableName = this.inferVarNameInUpdateSql(rawSql, startPos, endPos);
                break;
            }
            case INSERT: {
                variableName = this.inferVarNameInInsertSql(rawSql, endPos);
                break;
            }
            case MERGE: {
                variableName = this.inferVarNameInMergeSql(rawSql, startPos, endPos);
                break;
            }
        }
        if (variableName == null) {
            throw new EqlConfigException("unable to parse #?# in " + rawSql);
        }
        return variableName;
    }

    private String inferVarNameInMergeSql(String rawSql, int startPos, int endPos) {
        String upperCaseRawSql = rawSql.toUpperCase();
        int updatePos = upperCaseRawSql.indexOf("UPDATE");
        int insertPos = upperCaseRawSql.indexOf("INSERT");
        if (updatePos < 0 && insertPos >= 0) {
            return this.inferVarNameInInsertSql(rawSql, endPos);
        }
        if (updatePos >= 0 && insertPos < 0) {
            return this.inferVarNameInUpdateSql(rawSql, startPos, endPos);
        }
        int minPos = Math.min(updatePos, insertPos);
        if (minPos == updatePos && endPos < insertPos || minPos == insertPos && endPos > updatePos) {
            return this.inferVarNameInUpdateSql(rawSql, startPos, endPos);
        }
        if (minPos == updatePos && endPos > insertPos || minPos == insertPos && endPos < updatePos) {
            return this.inferVarNameInInsertSql(rawSql, endPos);
        }
        return null;
    }

    private String inferVarNameInInsertSql(String rawSql, int endPos) {
        int insertPos = rawSql.toUpperCase().indexOf("INSERT");
        int leftBracket = rawSql.indexOf(40, insertPos + 1);
        int rightBracket = rawSql.indexOf(41, leftBracket + 1);
        if (leftBracket < 0 || rightBracket < 0) {
            return null;
        }
        String fieldsStr = rawSql.substring(leftBracket + 1, rightBracket);
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        String[] fields = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)fieldsStr), String.class);
        int valuePos = rawSql.toUpperCase().indexOf("VALUES");
        String valuesPart = S.substrInQuotes(rawSql, '(', valuePos + "VALUES".length());
        int leftBracketPos = rawSql.indexOf(40, valuePos + "VALUES".length());
        String parseLeft = rawSql.substring(leftBracketPos + 1, endPos);
        String[] leftValues = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)parseLeft), String.class);
        String[] values = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)valuesPart), String.class);
        for (int i = leftValues.length; i < fields.length; ++i) {
            Matcher matcher = questionPattern.matcher(values[i]);
            if (!matcher.matches()) continue;
            return fields[i];
        }
        return null;
    }

    private String inferVarNameInUpdateSql(String rawSql, int startPos, int endPos) {
        String substr = rawSql.substring(startPos, endPos);
        Matcher matcher = lastWord.matcher(substr);
        if (!matcher.matches()) {
            throw new EqlConfigException("\u65e0\u6cd5\u89e3\u6790#?#\uff1a " + substr);
        }
        return matcher.group(1);
    }

    private void parsePlaceholders(List<String> placeHolders, List<String> placeHolderOptions) {
        ArrayList<EqlParamPlaceholder> paramPlaceholders = new ArrayList<EqlParamPlaceholder>();
        int ii = placeHolders.size();
        for (int i = 0; i < ii; ++i) {
            String placeHolder = placeHolders.get(i);
            String placeHolderOption = placeHolderOptions.get(i);
            EqlParamPlaceholder paramPlaceholder = new EqlParamPlaceholder();
            paramPlaceholders.add(paramPlaceholder);
            paramPlaceholder.setPlaceholder(placeHolder);
            paramPlaceholder.setOption(placeHolderOption);
            if (placeHolder.length() == 0) {
                paramPlaceholder.setPlaceholderType(PlaceholderType.AUTO_SEQ);
                continue;
            }
            if (S.isInteger(placeHolder)) {
                paramPlaceholder.setPlaceholderType(PlaceholderType.MANU_SEQ);
                paramPlaceholder.setSeq(Integer.parseInt(placeHolder, 10));
                continue;
            }
            paramPlaceholder.setPlaceholderType(PlaceholderType.VAR_NAME);
        }
        this.result.setPlaceHolderType(this.setAndCheckPlaceholderInType(paramPlaceholders, EqlParamPlaceholder.InOut.OUT));
        this.result.setPlaceHolderOutType(this.setAndCheckPlaceholderInType(paramPlaceholders, EqlParamPlaceholder.InOut.IN));
        if (this.result.getPlaceHolderType() == PlaceholderType.UNSET) {
            this.result.setPlaceHolderType(this.result.getPlaceHolderOutType());
        }
        this.result.setPlaceHolders(paramPlaceholders.toArray(new EqlParamPlaceholder[0]));
    }

    private PlaceholderType setAndCheckPlaceholderInType(List<EqlParamPlaceholder> paramPlaceholders, EqlParamPlaceholder.InOut inOut) {
        PlaceholderType placeHolderInType = PlaceholderType.UNSET;
        for (EqlParamPlaceholder paramPlaceholder : paramPlaceholders) {
            if (placeHolderInType == paramPlaceholder.getPlaceholderType() || paramPlaceholder.getInOut() == inOut) continue;
            if (placeHolderInType != PlaceholderType.UNSET) {
                throw new EqlConfigException("[" + (this.eqlUniqueSqlId != null ? this.eqlUniqueSqlId.getSqlId() : this.templateSql) + "] with different param binding types");
            }
            placeHolderInType = paramPlaceholder.getPlaceholderType();
        }
        if (placeHolderInType == PlaceholderType.MANU_SEQ && this.result.getSqlType() == EqlType.CALL) {
            throw new EqlConfigException("[" + (this.eqlUniqueSqlId != null ? this.eqlUniqueSqlId.getSqlId() : this.templateSql) + "] is a procedure without manually bind seq support");
        }
        return placeHolderInType;
    }
}

