/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.base.DynamicLanguageDriver;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.DefaultDynamicLanguageDriver;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.EqlBlockParser;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.settings.EqlFileGlobalSettings;

public class EqlParser {
    static Pattern blockPattern = Pattern.compile("\\[\\s*([\\w\\.\\-\\d]+)\\b(.*)\\]");
    private Map<String, EqlBlock> blocks = Maps.newHashMap();
    private String sqlClassPath;
    private List<String> sqlLines = null;
    private DynamicLanguageDriver dynamicLanguageDriver;
    private EqlBlock block = null;
    private EqlResourceLoader eqlResourceLoader;
    private boolean sqlParseDelay;
    static Pattern globalSettingsPattern = Pattern.compile("global\\s+settings\\s+(.+)");
    static Pattern includePattern = Pattern.compile("(include|ref)\\s+([\\w\\.\\-\\d]+)");
    static Pattern importPattern = Pattern.compile("import\\s+([/.\\w]+)(\\s+.*)?");

    public EqlParser(EqlResourceLoader eqlResourceLoader, String sqlClassPath) {
        this.eqlResourceLoader = eqlResourceLoader;
        this.sqlClassPath = sqlClassPath;
        if (eqlResourceLoader != null) {
            this.dynamicLanguageDriver = eqlResourceLoader.getDynamicLanguageDriver();
        }
        if (this.dynamicLanguageDriver == null) {
            this.dynamicLanguageDriver = new DefaultDynamicLanguageDriver();
        }
    }

    public Map<String, EqlBlock> delayParse(String eqlStr) {
        this.sqlParseDelay = true;
        return this.parse(eqlStr);
    }

    public Map<String, EqlBlock> parse(String eqlStr) {
        Iterable lines = Splitter.on((char)'\n').trimResults().split((CharSequence)eqlStr);
        int lineNo = 0;
        for (String line : lines) {
            ++lineNo;
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith("--")) {
                String cleanLine = ParserUtils.substr(line, "--".length());
                if (this.importOtherSqlFile(cleanLine) || this.includeOtherSqlId(cleanLine) || this.globalSettings(cleanLine)) continue;
                Matcher matcher = blockPattern.matcher(cleanLine);
                if (matcher.matches()) {
                    this.parsePreviousBlock();
                    String sqlId = matcher.group(1);
                    String options = matcher.group(2);
                    this.block = new EqlBlock(this.sqlClassPath, sqlId, options, lineNo);
                    this.addBlock(this.block);
                    continue;
                }
            }
            if (this.block == null) continue;
            this.sqlLines.add(line);
        }
        this.parsePreviousBlock();
        return this.blocks;
    }

    private boolean globalSettings(String cleanLine) {
        Matcher matcher = globalSettingsPattern.matcher(cleanLine);
        if (!matcher.matches()) {
            return false;
        }
        String globalSettings = matcher.group(1).trim();
        EqlFileGlobalSettings.process(this.sqlClassPath, globalSettings);
        return true;
    }

    private boolean includeOtherSqlId(String cleanLine) {
        Matcher matcher = includePattern.matcher(cleanLine);
        if (!matcher.matches()) {
            return false;
        }
        if (this.block == null) {
            return true;
        }
        String includeSqlId = matcher.group(2);
        EqlBlock eqlBlock = this.blocks.get(includeSqlId);
        if (eqlBlock == null) {
            throw new RuntimeException(cleanLine + " not found");
        }
        this.sqlLines.addAll(eqlBlock.getSqlLines());
        String ref = matcher.group(1);
        if (!"ref".equals(ref)) {
            this.sqlLines.add(";");
        }
        return true;
    }

    private boolean importOtherSqlFile(String cleanLine) {
        Matcher matcher = importPattern.matcher(cleanLine);
        if (!matcher.matches()) {
            return false;
        }
        this.parsePreviousBlock();
        String classPath = matcher.group(1).trim();
        String patterns = ParserUtils.trim(matcher.group(2));
        if (classPath.equals(this.sqlClassPath)) {
            return true;
        }
        Map<String, EqlBlock> importRes = this.eqlResourceLoader.load(classPath);
        if (ParserUtils.isBlank(patterns)) {
            this.importSqlBlocks(cleanLine, importRes);
            return true;
        }
        HashMap temp = Maps.newHashMap();
        Splitter splitter = Splitter.onPattern((String)"\\s+").omitEmptyStrings().trimResults();
        for (String pattern : splitter.split((CharSequence)patterns)) {
            for (EqlBlock eqlBlock : importRes.values()) {
                if (!EqlParser.wildCardMatch(eqlBlock.getSqlId(), pattern)) continue;
                temp.put(eqlBlock.getSqlId(), eqlBlock);
            }
        }
        this.importSqlBlocks(cleanLine, temp);
        return true;
    }

    private void importSqlBlocks(String cleanLine, Map<String, EqlBlock> temp) {
        for (EqlBlock eqlBlock : temp.values()) {
            if (this.blocks.containsKey(eqlBlock.getSqlId())) {
                throw new RuntimeException(eqlBlock.getSqlId() + " deplicated when " + cleanLine + " in " + this.sqlClassPath);
            }
            this.blocks.put(eqlBlock.getSqlId(), eqlBlock);
        }
    }

    private void addBlock(EqlBlock eqlBlock) {
        if (this.blocks.containsKey(eqlBlock.getSqlId())) {
            throw new RuntimeException(eqlBlock.getSqlId() + " deplicated in " + this.sqlClassPath);
        }
        this.blocks.put(eqlBlock.getSqlId(), eqlBlock);
        this.sqlLines = Lists.newArrayList();
    }

    private void parsePreviousBlock() {
        if (this.block != null && this.sqlLines != null && this.sqlLines.size() > 0) {
            new EqlBlockParser(this.dynamicLanguageDriver, this.sqlParseDelay).parse(this.block, this.sqlLines);
            this.block = null;
            this.sqlLines = null;
        }
    }

    public static boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        for (String card : cards = pattern.split("\\*")) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return true;
    }
}

