/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IfCondition;
import org.n3r.eql.parser.IfPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.util.S;

public class IfParser
implements PartParser {
    private String lastCondExpr;
    private MultiPart multiPart = new MultiPart();
    private List<IfCondition> conditions = Lists.newArrayList();
    static Pattern elseIfPattern = Pattern.compile("else\\s?if\\b(.*)", 2);

    public IfParser(String firstCondExpr) {
        this.lastCondExpr = firstCondExpr;
    }

    @Override
    public EqlPart createPart() {
        return new IfPart(this.conditions);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        boolean elseReached = false;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            Matcher matcher;
            String clearLine;
            String line = mergedLines.get(i);
            if (line.startsWith("--")) {
                clearLine = ParserUtils.substr(line, "--".length());
            } else {
                matcher = ParserUtils.inlineComment.matcher(line);
                if (matcher.matches()) {
                    clearLine = matcher.group(1).trim();
                } else {
                    this.multiPart.addPart(new LiteralPart(line));
                    continue;
                }
            }
            if ("end".equalsIgnoreCase(clearLine)) {
                this.newCondition();
                return i + 1;
            }
            if ("else".equalsIgnoreCase(clearLine)) {
                this.newCondition();
                this.lastCondExpr = "true";
                elseReached = true;
                continue;
            }
            matcher = elseIfPattern.matcher(clearLine);
            if (matcher.matches()) {
                if (elseReached) {
                    throw new RuntimeException("syntax error, else if position is illegal");
                }
                this.newCondition();
                this.lastCondExpr = S.trimToEmpty(matcher.group(1));
                if (!S.isBlank(this.lastCondExpr)) continue;
                throw new RuntimeException("syntax error, no condition in else if");
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser == null) continue;
            i = partParser.parse(mergedLines, i + 1) - 1;
            this.multiPart.addPart(partParser.createPart());
        }
        return i;
    }

    private void newCondition() {
        if (Strings.isNullOrEmpty((String)this.lastCondExpr) || this.multiPart.size() == 0) {
            return;
        }
        this.conditions.add(new IfCondition(this.lastCondExpr, this.multiPart));
        this.lastCondExpr = null;
        this.multiPart = new MultiPart();
    }
}

