/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import java.util.regex.Matcher;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IffPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;

public class IffParser
implements PartParser {
    private final String expr;
    private LiteralPart part = new LiteralPart("");

    public IffParser(String expr) {
        this.expr = expr;
    }

    @Override
    public EqlPart createPart() {
        return new IffPart(this.expr, this.part);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            PartParser partParser;
            String line = mergedLines.get(i);
            String clearLine = this.parseClearLine(line);
            if ("end".equalsIgnoreCase(clearLine)) {
                return i;
            }
            PartParser partParser2 = partParser = clearLine == null ? null : PartParserFactory.tryParse(clearLine);
            if (partParser != null) {
                return i;
            }
            if (clearLine != null) {
                this.part.appendComment(line);
                continue;
            }
            this.part.appendSql(line);
        }
        return i;
    }

    private String parseClearLine(String line) {
        if (line.startsWith("--")) {
            return ParserUtils.substr(line, "--".length());
        }
        Matcher matcher = ParserUtils.inlineComment.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }
}

