/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IfCondition;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.parser.SwitchPart;

public class SwitchParser
implements PartParser {
    private final String condition;
    private List<IfCondition> cases = Lists.newArrayList();
    private String lastCondExpr;
    private MultiPart multiPart = new MultiPart();
    private EqlPart lastPart;
    static Pattern casePattern = Pattern.compile("case\\s+(.*)", 2);

    public SwitchParser(String condition) {
        this.condition = condition;
    }

    @Override
    public EqlPart createPart() {
        return new SwitchPart(this.condition, this.cases);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        boolean defaultReached = false;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            Matcher matcher;
            String clearLine;
            String line = mergedLines.get(i);
            if (line.startsWith("--")) {
                clearLine = ParserUtils.substr(line, "--".length());
            } else {
                matcher = ParserUtils.inlineComment.matcher(line);
                if (matcher.matches()) {
                    clearLine = matcher.group(1).trim();
                } else {
                    this.lastPart = new LiteralPart(line);
                    this.multiPart.addPart(this.lastPart);
                    continue;
                }
            }
            if ("end".equalsIgnoreCase(clearLine)) {
                this.newCondition();
                return i + 1;
            }
            if ("default".equalsIgnoreCase(clearLine)) {
                this.newCondition();
                this.lastCondExpr = "";
                defaultReached = true;
                continue;
            }
            matcher = casePattern.matcher(clearLine);
            if (matcher.matches()) {
                if (defaultReached) {
                    throw new RuntimeException("syntax error, case position is illegal");
                }
                this.newCondition();
                this.lastCondExpr = matcher.group(1);
                continue;
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser != null) {
                i = partParser.parse(mergedLines, i + 1) - 1;
                this.lastPart = partParser.createPart();
                this.multiPart.addPart(this.lastPart);
                this.newCondition();
                continue;
            }
            if (!(this.lastPart instanceof LiteralPart)) continue;
            ((LiteralPart)this.lastPart).appendComment(line);
        }
        return i;
    }

    private void newCondition() {
        if (this.lastCondExpr == null || this.multiPart.size() == 0) {
            return;
        }
        this.cases.add(new IfCondition(this.lastCondExpr, this.multiPart));
        this.lastCondExpr = null;
        this.lastPart = null;
        this.multiPart = new MultiPart();
    }
}

