/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlConfigException;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.S;

public class EqlJndiConnection
implements EqlConnection {
    private DataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new EqlConfigException("create connection fail", e);
        }
    }

    @Override
    public void destroy() {
        this.dataSource = null;
    }

    @Override
    public void initialize(EqlConfig eqlConfig) {
        String jndiName = eqlConfig.getStr("jndiName");
        String initial = eqlConfig.getStr("java.naming.factory.initial");
        String url = eqlConfig.getStr("java.naming.provider.url");
        this.createDataSource(jndiName, initial, url);
    }

    private void createDataSource(String jndiName, String initial, String url) {
        try {
            Hashtable<String, String> context = new Hashtable<String, String>();
            if (S.isNotEmpty(url)) {
                context.put("java.naming.provider.url", url);
            }
            if (S.isNotEmpty(initial)) {
                context.put("java.naming.factory.initial", initial);
            }
            this.dataSource = (DataSource)new InitialContext(context).lookup(jndiName);
        }
        catch (NamingException e) {
            throw new EqlConfigException("create data source fail", e);
        }
    }
}

