/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAddress {
    private static Logger logger = LoggerFactory.getLogger(HostAddress.class);
    private static String ip;
    private static String host;

    public static String getHost() {
        return host;
    }

    public static String getIp() {
        return ip;
    }

    private static String left(String string, int len) {
        return string.length() <= len ? string : string.substring(0, len);
    }

    static {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName("bond0");
        }
        catch (SocketException e) {
            logger.warn("Get NetworkInterface bond0 fail", (Throwable)e);
        }
        InetAddress inetAddress = null;
        if (null != ni) {
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ia = addresses.nextElement();
                if (ia instanceof Inet6Address) continue;
                inetAddress = ia;
                ip = HostAddress.left(ia.getHostAddress(), 20);
                break;
            }
        } else {
            try {
                inetAddress = InetAddress.getLocalHost();
                ip = inetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.warn("getHostAddress fail", (Throwable)e);
            }
        }
        if (inetAddress != null) {
            host = HostAddress.left(inetAddress.getHostName(), 50);
        }
    }
}

