/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.impl.DefaultEqlConfigDecorator;
import org.n3r.eql.util.EqlPropertiesConfigFactory;

public class EqlConfigCache {
    static LoadingCache<String, EqlConfig> eqlConfigLocal = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, EqlConfig>(){

        public EqlConfig load(String key) {
            EqlConfig eqlConfig = EqlPropertiesConfigFactory.parseEqlProperties(key);
            return new DefaultEqlConfigDecorator(eqlConfig);
        }
    });

    public static void putAsDefault(EqlConfig eqlConfig) {
        EqlConfigCache.put("DEFAULT", eqlConfig);
    }

    public static void put(String eqlConfigName, EqlConfig eqlConfig) {
        eqlConfigLocal.put((Object)eqlConfigName, (Object)eqlConfig);
    }

    public static EqlConfig getEqlConfig(String eqlConfigName) {
        return (EqlConfig)eqlConfigLocal.getUnchecked((Object)eqlConfigName);
    }
}

