/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.refer;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Set;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.dbfieldcryptor.EqlSecretFieldsConnectionProxy;
import org.n3r.eql.dbfieldcryptor.SecretFieldsConfigable;
import org.n3r.eql.util.S;

public class ReferSecretFieldsConfig
implements SecretFieldsConfigable {
    private Set<String> secretFieldsConfig;

    public ReferSecretFieldsConfig() {
        EqlConfig eqlConfig = EqlSecretFieldsConnectionProxy.threadLocal.get();
        if (eqlConfig == null) {
            return;
        }
        String secureDatabaseFields = eqlConfig.getStr("securetDatabaseFields.define");
        if (S.isBlank(secureDatabaseFields)) {
            return;
        }
        Splitter splitter = Splitter.onPattern((String)"\\s+").trimResults().omitEmptyStrings();
        Iterable secureFields = splitter.split((CharSequence)secureDatabaseFields.toUpperCase());
        this.secretFieldsConfig = Sets.newHashSet((Iterable)secureFields);
    }

    @Override
    public Set<String> getSecretFieldsConfig() {
        return this.secretFieldsConfig;
    }
}

