/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.diamond;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.n3r.diamond.client.DiamondManager;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.AbstractEqlResourceLoader;
import org.n3r.eql.impl.EqlResourceLoaderHelper;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.impl.FileEqlResourceLoader;
import org.n3r.eql.parser.EqlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondEqlResourceLoader
extends AbstractEqlResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(DiamondEqlResourceLoader.class);
    static Cache<String, Optional<Map<String, EqlBlock>>> fileCache = CacheBuilder.newBuilder().build();
    static LoadingCache<EqlUniqueSqlId, Optional<EqlBlock>> sqlCache = EqlResourceLoaderHelper.buildSqlCache(fileCache);
    static FileEqlResourceLoader fileLoader = new FileEqlResourceLoader();

    @Override
    public EqlBlock loadEqlBlock(String sqlClassPath, String sqlId) {
        this.load(this, sqlClassPath);
        Optional blockOptional = (Optional)sqlCache.getUnchecked((Object)new EqlUniqueSqlId(sqlClassPath, sqlId));
        if (blockOptional.isPresent()) {
            return (EqlBlock)blockOptional.get();
        }
        EqlBlock eqlBlock = fileLoader.loadEqlBlock(sqlClassPath, sqlId);
        if (eqlBlock != null) {
            return eqlBlock;
        }
        throw new RuntimeException("unable to find sql id " + sqlId);
    }

    @Override
    public Map<String, EqlBlock> load(String classPath) {
        return this.load(this, classPath);
    }

    private Map<String, EqlBlock> load(EqlResourceLoader eqlResourceLoader, String sqlClassPath) {
        String dataId = sqlClassPath.replaceAll("/", ".");
        try {
            return (Map)((Optional)fileCache.get((Object)sqlClassPath, () -> {
                DiamondManager manager = new DiamondManager("EQL", dataId);
                manager.addDiamondListener(diamondStone -> EqlResourceLoaderHelper.updateBlockCache(diamondStone.getContent(), eqlResourceLoader, sqlClassPath, sqlCache, fileCache));
                String sqlContent = manager.getDiamond();
                if (sqlContent == null) {
                    log.warn("classpath sql {} not found", (Object)dataId);
                    return Optional.absent();
                }
                return Optional.of(EqlResourceLoaderHelper.updateFileCache(sqlContent, eqlResourceLoader, sqlClassPath, this.eqlLazyLoad));
            })).orNull();
        }
        catch (ExecutionException e) {
            throw Throwables.getRootCause((Throwable)e);
        }
    }
}

