/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.n3r.eql.map.FromDbMapper;
import org.n3r.eql.map.MapperFactory;
import org.n3r.eql.map.RsAware;
import org.n3r.eql.map.ToDbMapper;
import org.n3r.eql.util.BlackcatUtils;

public class DefaultMapperFactory
implements MapperFactory {
    public static final boolean HasJodaDateTime = BlackcatUtils.classExists("org.joda.time.DateTime");

    @Override
    public void addToDbMapper(Set<ToDbMapper> mappers) {
        if (HasJodaDateTime) {
            mappers.add(new DateTimeToDbMapper());
            mappers.add(new LocalDateToDbMapper());
            mappers.add(new LocalTimeToDbMapper());
        }
    }

    @Override
    public void addFromDbMapper(Set<FromDbMapper> mappers) {
        if (HasJodaDateTime) {
            mappers.add(new DateTimeFromDbMapper());
            mappers.add(new LocalDateFromDbMapper());
            mappers.add(new LocalTimeFromDbMapper());
        }
        mappers.add(new ClobFromDbMapper());
        mappers.add(new BlobFromDbMapper());
        mappers.add(new BigDecimalFromDbMapper());
        mappers.add(new TimeFromDbMapper());
        mappers.add(new TimestampFromDbMapper());
        mappers.add(new UtilDateFromDbMapper());
    }

    public static class UtilDateFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return java.util.Date.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getTimestamp(index);
        }
    }

    public static class TimestampFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return Timestamp.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getTimestamp(index);
        }
    }

    public static class TimeFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return Time.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getTime(index);
        }
    }

    public static class BigDecimalFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return BigDecimal.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getBigDecimal(index);
        }
    }

    public static class BlobFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return Blob.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getBlob(index);
        }
    }

    public static class ClobFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return Clob.class == clazz;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            return rs.getClob(index);
        }
    }

    public static class LocalTimeFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == LocalTime.class;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            Time time = rs.getTime(index);
            if (time == null) {
                return null;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(time);
            return new LocalTime(c.get(11), c.get(12), c.get(13), c.get(14));
        }
    }

    public static class LocalDateFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == org.joda.time.LocalDate.class;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            Date date = rs.getDate(index);
            if (date == null) {
                return null;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return new org.joda.time.LocalDate(c.get(1), c.get(2) + 1, c.get(5));
        }
    }

    public static class DateTimeFromDbMapper
    implements FromDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == DateTime.class;
        }

        @Override
        public Object map(RsAware rs, int index) throws SQLException {
            Timestamp ts = rs.getTimestamp(index);
            return ts == null ? null : new DateTime(ts.getTime());
        }
    }

    public static class LocalTimeToDbMapper
    implements ToDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == LocalTime.class;
        }

        @Override
        public Object map(Object obj) {
            LocalTime t = (LocalTime)obj;
            return Time.valueOf(java.time.LocalTime.of(t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond()));
        }
    }

    public static class LocalDateToDbMapper
    implements ToDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == org.joda.time.LocalDate.class;
        }

        @Override
        public Object map(Object obj) {
            org.joda.time.LocalDate d = (org.joda.time.LocalDate)obj;
            return Date.valueOf(LocalDate.of(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth()));
        }
    }

    public static class DateTimeToDbMapper
    implements ToDbMapper {
        @Override
        public boolean support(Class<?> clazz) {
            return clazz == DateTime.class;
        }

        @Override
        public Object map(Object obj) {
            return new Timestamp(((DateTime)obj).getMillis());
        }
    }
}

