/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix.mapper;

import com.google.common.collect.Lists;
import java.util.List;
import org.n3r.eql.matrix.RealPartition;
import org.n3r.eql.matrix.impl.GotoRealPartition;
import org.n3r.eql.matrix.impl.MatrixMapper;
import org.n3r.eql.util.S;

public class DefaultMatrixMapper
implements MatrixMapper {
    private String defaultValue;
    private List<MapCase> mapCases = Lists.newArrayList();
    private int gotoAnotherRule = -1;

    @Override
    public RealPartition map(String value) {
        for (MapCase mapCase : this.mapCases) {
            if (!mapCase.left.equals(value)) continue;
            return RealPartition.parse(mapCase.right);
        }
        if (this.gotoAnotherRule >= 0) {
            return new GotoRealPartition(this.gotoAnotherRule);
        }
        return RealPartition.parse(this.defaultValue.replaceAll("\\$", value));
    }

    @Override
    public void config(List<String> mapperParams) {
        int size = mapperParams.size();
        if (size == 0) {
            throw new RuntimeException("mapper is invalid");
        }
        int ii = size;
        for (int i = 0; i < ii; ++i) {
            String mapCase = mapperParams.get(i);
            int colonPos = mapCase.indexOf(58);
            if (colonPos < 0) {
                if (i == ii - 1) {
                    if (mapCase.startsWith("rule->")) {
                        this.gotoAnotherRule = Integer.parseInt(mapCase.substring("rule->".length()));
                        break;
                    }
                    this.defaultValue = mapCase;
                    break;
                }
                throw new RuntimeException("mapper is invalid");
            }
            if (colonPos == 0 || colonPos == mapCase.length() - 1) {
                throw new RuntimeException("mapper is invalid");
            }
            String left = mapCase.substring(0, colonPos);
            String right = S.trimLeft(mapCase.substring(colonPos + 1));
            this.mapCases.add(new MapCase(left, right));
        }
    }

    private static final class MapCase {
        public final String left;
        public final String right;

        public MapCase(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapCase)) {
                return false;
            }
            MapCase other = (MapCase)o;
            String this$left = this.getLeft();
            String other$left = other.getLeft();
            if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                return false;
            }
            String this$right = this.getRight();
            String other$right = other.getRight();
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            String $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultMatrixMapper.MapCase(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
        }
    }
}

