/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class StringTable {
    private final String[] table;
    private final int columnCount;

    public StringTable(String tableString) {
        this(StringTable.convert(tableString));
    }

    public StringTable(String[] table) {
        this.table = StringTable.convert(table);
        this.columnCount = StringTable.findColumnCount(table);
        this.checkTable();
    }

    private static String[] convert(String tableString) {
        String[] parts = tableString.split(",");
        return StringTable.convert(parts);
    }

    private static String[] convert(String[] table) {
        int ii = table.length;
        for (int i = 0; i < ii; ++i) {
            if (!"null".equals(table[i])) continue;
            table[i] = null;
        }
        return table;
    }

    private static int findColumnCount(String[] table) {
        int ii = table.length;
        for (int i = 0; i < ii; ++i) {
            if (table[i] != null) continue;
            return i + 1;
        }
        throw new RuntimeException("bad table format: no null to identify rows end");
    }

    private void checkTable() {
        if (this.table.length % this.columnCount > 0) {
            throw new RuntimeException("bad table format : columns in rows is not consistent");
        }
    }

    public Map<String, String> findRow(String rowkey) {
        HashMap row = Maps.newHashMap();
        int rowIndex = this.findRow(this.table, this.columnCount, rowkey);
        for (int j = 1; j < this.columnCount - 1; ++j) {
            String key = this.table[j];
            String value = this.table[rowIndex * this.columnCount + j];
            row.put(key, value);
        }
        return row;
    }

    private int findRow(String[] config, int columnCount, String rowkey) {
        int maxRows = config.length / columnCount;
        for (int row = 1; row < maxRows; ++row) {
            String rowTenantId = config[row * columnCount];
            if (!rowkey.equals(rowTenantId)) continue;
            return row;
        }
        throw new RowNotFoundException("row is not found with rowkey" + rowkey);
    }

    public static class RowNotFoundException
    extends RuntimeException {
        public RowNotFoundException(String msg) {
            super(msg);
        }
    }
}

