/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.ex.EqlConfigException;
import org.n3r.eql.map.EqlDynamic;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.PlaceholderType;
import org.n3r.eql.util.S;

public class DynamicParser {
    private static final Pattern DYNAMIC_PATTERN = Pattern.compile("'?\\$(.*?)\\$'?");
    private EqlDynamic dynamicSql;
    private String rawSql;

    public EqlDynamic parseRawSql(String rawSql) {
        this.rawSql = rawSql;
        this.dynamicSql = new EqlDynamic();
        Matcher matcher = DYNAMIC_PATTERN.matcher(rawSql);
        ArrayList placeHolders = Lists.newArrayList();
        ArrayList sqlPieces = Lists.newArrayList();
        int startPos = 0;
        while (matcher.find()) {
            String placeHolder = matcher.group(1).trim();
            placeHolders.add(placeHolder);
            sqlPieces.add(rawSql.substring(startPos, matcher.start()));
            startPos = matcher.end();
        }
        if (startPos == 0) {
            return null;
        }
        sqlPieces.add(rawSql.substring(startPos));
        this.dynamicSql.setSqlPieces(sqlPieces);
        this.parsePlaceholders(placeHolders);
        return this.dynamicSql;
    }

    private void parsePlaceholders(List<String> placeHolders) {
        ArrayList<EqlParamPlaceholder> paramPlaceholders = new ArrayList<EqlParamPlaceholder>();
        PlaceholderType placeHoldertype = PlaceholderType.UNSET;
        for (String placeHolder : placeHolders) {
            EqlParamPlaceholder paramPlaceholder = new EqlParamPlaceholder();
            paramPlaceholders.add(paramPlaceholder);
            paramPlaceholder.setPlaceholder(placeHolder);
            if (placeHolder.length() == 0) {
                paramPlaceholder.setPlaceholderType(PlaceholderType.AUTO_SEQ);
            } else if (S.isInteger(placeHolder)) {
                paramPlaceholder.setPlaceholderType(PlaceholderType.MANU_SEQ);
                paramPlaceholder.setSeq(Integer.valueOf(placeHolder));
            } else {
                paramPlaceholder.setPlaceholderType(PlaceholderType.VAR_NAME);
            }
            placeHoldertype = paramPlaceholder.getPlaceholderType();
        }
        for (EqlParamPlaceholder pPlaceholder : paramPlaceholders) {
            if (placeHoldertype == pPlaceholder.getPlaceholderType()) continue;
            throw new EqlConfigException("[" + this.rawSql + "]\u4e2d\u5b9a\u4e49\u7684SQL\u52a8\u6001\u66ff\u6362\u8bbe\u7f6e\u7c7b\u578b\u4e0d\u4e00\u81f4");
        }
        this.dynamicSql.setPlaceholdertype(placeHoldertype);
        EqlParamPlaceholder[] placeholders = paramPlaceholders.toArray(new EqlParamPlaceholder[0]);
        this.dynamicSql.setPlaceholders(placeholders);
    }
}

