/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Objects;
import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlDynamic;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.DynamicParser;
import org.n3r.eql.util.Names;

public class DynamicReplacer {
    private Object[] dynamics;
    private EqlRun eqlRun;

    public void replaceDynamics(EqlConfigDecorator eqlConfig, EqlRun eqlRun) {
        EqlDynamic eqlDynamic;
        boolean dynamicsEnabled = this.isDynamicsEnabled(eqlConfig);
        if (!dynamicsEnabled) {
            return;
        }
        this.eqlRun = eqlRun;
        this.dynamics = eqlRun.getDynamics();
        if (this.dynamics != null && this.dynamics.length > 0 && eqlRun.getEqlDynamic() == null) {
            eqlRun.setEqlDynamic(new DynamicParser().parseRawSql(eqlRun.getRunSql()));
            eqlRun.setEvalEqlDynamic(new DynamicParser().parseRawSql(eqlRun.getEvalSqlTemplate()));
        }
        if ((eqlDynamic = eqlRun.getEqlDynamic()) == null) {
            return;
        }
        eqlRun.setRunSql(this.replaceRunSqlDynamics(eqlDynamic));
        eqlRun.setEvalSqlTemplate(this.replaceRunSqlDynamics(eqlRun.getEvalEqlDynamic()));
    }

    private boolean isDynamicsEnabled(EqlConfigDecorator eqlConfig) {
        String dynamicsEnabledConfig = eqlConfig.getStr("dynamics.enabled");
        return dynamicsEnabledConfig == null || "yes".equalsIgnoreCase(dynamicsEnabledConfig) || "true".equalsIgnoreCase(dynamicsEnabledConfig) || "on".equalsIgnoreCase(dynamicsEnabledConfig);
    }

    private String replaceRunSqlDynamics(EqlDynamic eqlDynamic) {
        List<String> sqlPieces = eqlDynamic.getSqlPieces();
        StringBuilder runSql = new StringBuilder(sqlPieces.get(0));
        int ii = sqlPieces.size();
        switch (eqlDynamic.getPlaceholdertype()) {
            case AUTO_SEQ: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicByIdx(i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
            case MANU_SEQ: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicBySeq(eqlDynamic, i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
            case VAR_NAME: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicByName(eqlDynamic, i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
        }
        return runSql.toString();
    }

    private Object findDynamicByIdx(int index) {
        if (index < this.dynamics.length) {
            return this.dynamics[index];
        }
        throw new EqlExecuteException("[" + this.eqlRun.getSqlId() + "] lack dynamic params");
    }

    private Object findDynamicBySeq(EqlDynamic eqlDynamic, int index) {
        return this.findDynamicByIdx(eqlDynamic.getPlaceholders()[index].getSeq() - 1);
    }

    private Object findDynamicByName(EqlDynamic eqlDynamic, int index) {
        String varName = eqlDynamic.getPlaceholders()[index].getPlaceholder();
        ExpressionEvaluator evaluator = this.eqlRun.getEqlConfig().getExpressionEvaluator();
        Object property = evaluator.evalDynamic(varName, this.eqlRun);
        if (property != null) {
            return property;
        }
        String propertyName = Names.underscoreNameToPropertyName(varName);
        if (!Objects.equal((Object)propertyName, (Object)varName)) {
            property = evaluator.evalDynamic(propertyName, this.eqlRun);
        }
        return property;
    }
}

