/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;

public class ForPart
implements EqlPart {
    private MultiPart part;
    private String item;
    private String index;
    private String collection;
    private String open;
    private String separator;
    private String close;
    private static Pattern PARAM_PATTERN = Pattern.compile("#\\s*(.+?)\\s*#");
    private static Pattern DYNAMIC_PATTERN = Pattern.compile("\\$\\s*(.+?)\\s*\\$");

    @Override
    public String evalSql(EqlRun eqlRun) {
        Iterable<?> items = EqlUtils.evalCollection(this.collection, eqlRun);
        if (items == null) {
            return "";
        }
        String collectionExpr = EqlUtils.collectionExprString(this.collection, eqlRun);
        Map<String, Object> preContext = eqlRun.getExecutionContext();
        HashMap<String, Object> context = new HashMap<String, Object>(preContext);
        eqlRun.setExecutionContext(context);
        StringBuilder str = new StringBuilder(this.open).append(' ');
        Pattern itemPattern = Pattern.compile("\\b(?<!.)" + this.item + "\\b");
        Pattern indexPattern = Pattern.compile("\\b(?<!.)" + this.index + "\\b");
        int i = -1;
        for (Object itemObj : items) {
            context.put(this.index, ++i);
            context.put(this.item, itemObj);
            String sql = this.part.evalSql(eqlRun);
            sql = this.processParams(PARAM_PATTERN, '#', itemPattern, indexPattern, collectionExpr, i, sql);
            sql = this.processParams(DYNAMIC_PATTERN, '$', itemPattern, indexPattern, collectionExpr, i, sql);
            if (i > 0 && S.isNotBlank(sql)) {
                str.append(this.separator);
            }
            str.append(sql);
        }
        str.append(this.close);
        eqlRun.setExecutionContext(preContext);
        return str.toString();
    }

    private String processParams(Pattern pattern, char ch, Pattern itemPattern, Pattern indexPattern, String collectionExpr, int idx, String sql) {
        int startIndex = 0;
        StringBuilder str = new StringBuilder();
        String colItem = collectionExpr + "[" + idx + "]";
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            str.append(sql, startIndex, matcher.start());
            startIndex = matcher.end();
            String expr = matcher.group(1);
            if (this.item.equals(expr)) {
                str.append(S.wrap(colItem, ch));
                continue;
            }
            if (this.index.equals(expr)) {
                str.append(idx);
                continue;
            }
            Matcher itemMatcher = itemPattern.matcher(expr);
            String s = itemMatcher.replaceAll(colItem);
            Matcher indexMatcher = indexPattern.matcher(s);
            s = indexMatcher.replaceAll("" + idx);
            str.append(S.wrap(S.escapeCrossAndDollar(s), ch));
        }
        if (startIndex < sql.length()) {
            str.append(sql.substring(startIndex));
        }
        return str.toString();
    }

    public ForPart(MultiPart part, String item, String index, String collection, String open, String separator, String close) {
        this.part = part;
        this.item = item;
        this.index = index;
        this.collection = collection;
        this.open = open;
        this.separator = separator;
        this.close = close;
    }

    public MultiPart getPart() {
        return this.part;
    }
}

