/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.parser.TrimPart;
import org.n3r.eql.util.Pair;
import org.n3r.eql.util.PairsParser;

public class TrimParser
implements PartParser {
    private final String prefix;
    private final String suffix;
    private final String prefixOverrides;
    private final String suffixOverrides;
    private MultiPart multiPart = new MultiPart();

    public TrimParser(String options) {
        Map<String, String> optionsMap = new PairsParser().parse(options.trim());
        this.prefix = optionsMap.get("prefix");
        this.suffix = optionsMap.get("suffix");
        this.prefixOverrides = optionsMap.get("prefixOverrides");
        this.suffixOverrides = optionsMap.get("suffixOverrides");
    }

    @Override
    public EqlPart createPart() {
        return new TrimPart(this.prefix, this.suffix, this.prefixOverrides, this.suffixOverrides, this.multiPart);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            String line = mergedLines.get(i);
            Pair<String, LiteralPart> clearLineRet = TrimParser.cleanLine(line, this.multiPart);
            if (clearLineRet._2 != null) continue;
            String clearLine = (String)clearLineRet._1;
            if ("end".equalsIgnoreCase(clearLine)) {
                return i + 1;
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser == null) continue;
            i = partParser.parse(mergedLines, i + 1) - 1;
            this.multiPart.addPart(partParser.createPart());
        }
        return i;
    }

    public static Pair<String, LiteralPart> cleanLine(String line, MultiPart multiPart) {
        if (line.startsWith("--")) {
            return Pair.of(ParserUtils.substr(line, "--".length()), null);
        }
        Matcher matcher = ParserUtils.inlineComment.matcher(line);
        if (matcher.matches()) {
            return Pair.of(matcher.group(1).trim(), null);
        }
        LiteralPart part = new LiteralPart(line);
        multiPart.addPart(part);
        return Pair.of(null, part);
    }
}

