/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.util.S;

public class TrimPart
implements EqlPart {
    private String prefix;
    private String suffix;
    private List<String> prefixOverrides;
    private List<String> suffixOverrides;
    private MultiPart multiPart;
    private String partSql;
    private String lowerSql;

    public TrimPart(String prefix, String suffix, String prefixOverrides, String suffixOverrides, MultiPart multiPart) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.prefixOverrides = this.split(prefixOverrides);
        this.suffixOverrides = this.split(suffixOverrides);
        this.multiPart = multiPart;
    }

    private List<String> split(String overrides) {
        if (S.isBlank(overrides)) {
            return Collections.emptyList();
        }
        return Splitter.on((char)'|').trimResults().omitEmptyStrings().splitToList((CharSequence)overrides.toLowerCase());
    }

    @Override
    public String evalSql(EqlRun eqlRun) {
        StringBuilder sql = new StringBuilder();
        this.partSql = this.multiPart.evalSql(eqlRun);
        if (!S.isBlank(this.partSql)) {
            this.override();
            if (S.isNotEmpty(this.prefix)) {
                sql.append(this.prefix).append(' ');
                this.partSql = S.trimLeft(this.partSql);
            }
            if (S.isNotEmpty(this.suffix)) {
                sql.append(S.trimRight(this.partSql));
                sql.append(' ').append(this.suffix);
            } else {
                sql.append(this.partSql);
            }
        } else {
            sql.append(this.partSql);
        }
        return sql.toString();
    }

    private String override() {
        this.lowerSql = this.partSql.toLowerCase();
        for (String prefixOverride : this.prefixOverrides) {
            if (!this.lowerSql.startsWith(prefixOverride)) continue;
            this.overridePrefix(prefixOverride);
        }
        for (String suffixOverride : this.suffixOverrides) {
            if (!this.endsWith(suffixOverride)) continue;
            this.overrideSuffix(suffixOverride);
        }
        return this.partSql;
    }

    private boolean endsWith(String suffix) {
        return this.lowerSql.trim().endsWith(suffix);
    }

    private void overrideSuffix(String suffix) {
        String right = S.trimRight(this.lowerSql);
        int diff = this.lowerSql.length() - right.length();
        String diffStr = diff <= 0 ? "" : this.lowerSql.substring(right.length());
        int suffixLen = suffix.length();
        int strLen = right.length();
        if (strLen > suffixLen) {
            this.lowerSql = S.trimLeft(this.lowerSql.substring(0, strLen - suffixLen)) + diffStr;
            this.partSql = S.trimLeft(this.partSql.substring(0, strLen - suffixLen)) + diffStr;
        } else {
            this.lowerSql = "";
            this.partSql = "";
        }
    }

    private void overridePrefix(String prefix) {
        int startIndex = prefix.length();
        if (startIndex < this.lowerSql.length()) {
            this.lowerSql = this.lowerSql.substring(startIndex);
            this.partSql = this.partSql.substring(startIndex);
        } else {
            this.lowerSql = "";
            this.partSql = "";
        }
    }

    public MultiPart getParts() {
        return this.multiPart;
    }
}

