/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.util.Map;
import org.n3r.eql.EqlTran;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.Closes;

public class EqlJdbcTran
implements EqlTran {
    private EqlConnection eqlConnection;
    private Map<String, Connection> connections = Maps.newHashMap();

    public EqlJdbcTran(EqlConnection connection) {
        this.eqlConnection = connection;
    }

    @Override
    public void start() {
    }

    @Override
    public void commit() {
        for (Connection connection : this.connections.values()) {
            connection.commit();
        }
    }

    @Override
    public void rollback() {
        for (Connection connection : this.connections.values()) {
            connection.rollback();
        }
    }

    @Override
    public Connection getConn(EqlConfig eqlConfig, EqlRun eqlRun) {
        String dbName = this.eqlConnection.getDbName(eqlConfig, eqlRun);
        Connection connection = this.connections.get(dbName);
        if (connection != null) {
            eqlRun.setConnection(connection);
            return connection;
        }
        connection = this.eqlConnection.getConnection(dbName);
        if (connection == null) {
            throw new EqlExecuteException("EqlJdbcTran could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        this.connections.put(dbName, connection);
        if (eqlRun != null) {
            eqlRun.setConnection(connection);
        }
        return connection;
    }

    @Override
    public String getDriverName() {
        return this.eqlConnection.getDriverName();
    }

    @Override
    public String getJdbcUrl() {
        return this.eqlConnection.getJdbcUrl();
    }

    @Override
    public void close() {
        for (Connection connection : this.connections.values()) {
            Closes.closeQuietly(connection);
        }
    }
}

