/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import java.sql.Connection;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.trans.AbstractEqlConnection;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;

public class EqlJndiConnection
extends AbstractEqlConnection {
    private DataSource dataSource;

    @Override
    public Connection getConnection(String dbName) {
        return this.dataSource.getConnection();
    }

    @Override
    public void destroy() {
        this.dataSource = null;
    }

    @Override
    public String getDriverName() {
        return EqlUtils.getDriverNameFromConnection(this.dataSource);
    }

    @Override
    public String getJdbcUrl() {
        return EqlUtils.getJdbcUrlFromConnection(this.dataSource);
    }

    @Override
    public void initialize(EqlConfig eqlConfig) {
        String jndiName = eqlConfig.getStr("jndiName");
        String initial = eqlConfig.getStr("java.naming.factory.initial");
        String url = eqlConfig.getStr("java.naming.provider.url");
        this.createDataSource(jndiName, initial, url);
    }

    private void createDataSource(String jndiName, String initial, String url) {
        Hashtable<String, String> context = new Hashtable<String, String>();
        if (S.isNotEmpty(url)) {
            context.put("java.naming.provider.url", url);
        }
        if (S.isNotEmpty(initial)) {
            context.put("java.naming.factory.initial", initial);
        }
        this.dataSource = (DataSource)new InitialContext(context).lookup(jndiName);
    }
}

