/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans.spring;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.n3r.eql.trans.spring.EqlTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlTransactionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(EqlTransactionInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        EqlTransactionManager.start();
        try {
            Object retValue = invocation.proceed();
            EqlTransactionManager.commit();
            Object object = retValue;
            return object;
        }
        catch (Throwable throwable) {
            log.error("error", throwable);
            EqlTransactionManager.rollback();
            throw throwable;
        }
        finally {
            EqlTransactionManager.end();
        }
    }
}

