/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.util.P;

public class BeanPropertyReader {
    private Class<? extends Object> beanClass;
    private String property;
    private Object bean;
    private Object propertyValue;
    private boolean propertyExisted;
    private String capitalizedProperty;

    public BeanPropertyReader(Object bean, String property) {
        if (bean == null) {
            return;
        }
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        this.capitalizedProperty = StringUtils.capitalize((String)property);
        if (bean instanceof Map) {
            this.propertyValue = ((Map)bean).get(property);
            this.propertyExisted = this.propertyValue != null;
        } else {
            if (this.tryField()) {
                return;
            }
            if (this.tryGetMethod()) {
                return;
            }
            this.tryIsMethod();
        }
    }

    private void tryIsMethod() {
        try {
            Method isMethod = this.beanClass.getMethod("is" + this.capitalizedProperty, new Class[0]);
            Object value = isMethod.invoke(this.bean, new Object[0]);
            this.propertyExisted = true;
            this.propertyValue = P.toDbConvert(isMethod, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean tryGetMethod() {
        try {
            Method getMethod = this.beanClass.getMethod("get" + this.capitalizedProperty, new Class[0]);
            Object value = getMethod.invoke(this.bean, new Object[0]);
            this.propertyExisted = true;
            this.propertyValue = P.toDbConvert(getMethod, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean tryField() {
        try {
            Field keyField = this.beanClass.getDeclaredField(this.property);
            if (!keyField.isAccessible()) {
                keyField.setAccessible(true);
            }
            Object value = keyField.get(this.bean);
            this.propertyExisted = true;
            this.propertyValue = P.toDbConvert(keyField, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isPropertyExisted() {
        return this.propertyExisted;
    }
}

