/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.io.Closeable;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Scanner;

public class HostAddress {
    private static String ip;
    private static String host;

    public static String getHost() {
        return host;
    }

    public static String getIp() {
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hostname() {
        String string;
        Process proc = null;
        InputStream stream = null;
        Scanner s = null;
        try {
            proc = Runtime.getRuntime().exec("hostname");
            stream = proc.getInputStream();
            s = new Scanner(stream).useDelimiter("\\A");
            string = s.hasNext() ? s.next().trim() : "";
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = "unknown";
            }
            catch (Throwable throwable) {
                HostAddress.closeQuietly(stream);
                HostAddress.closeQuietly(s);
                if (proc != null) {
                    proc.destroy();
                }
                if (s != null) {
                    s.close();
                }
                throw throwable;
            }
            HostAddress.closeQuietly(stream);
            HostAddress.closeQuietly(s);
            if (proc != null) {
                proc.destroy();
            }
            if (s != null) {
                s.close();
            }
            return string2;
        }
        HostAddress.closeQuietly(stream);
        HostAddress.closeQuietly(s);
        if (proc != null) {
            proc.destroy();
        }
        if (s != null) {
            s.close();
        }
        return string;
    }

    public static void closeQuietly(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        StringBuilder ips = new StringBuilder();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (ni.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    ips.append(inetAddress.getHostAddress()).append(",");
                }
            }
        }
        catch (SocketException interfaces) {
            // empty catch block
        }
        if (ips.length() == 0) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                ip = localHost.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            ip = ips.deleteCharAt(ips.length() - 1).toString();
        }
        host = HostAddress.hostname();
    }
}

