/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.base.Preconditions;

public class KeyValue {
    private String key;
    private String value;

    public static KeyValue parse(String keyValue) {
        int equalPos = keyValue.indexOf(61);
        if (equalPos < 0) {
            return new KeyValue(keyValue, "");
        }
        Preconditions.checkState((equalPos != 0 ? 1 : 0) != 0, (Object)(keyValue + " is not a valid key value pair (key[=value]"));
        String key = keyValue.substring(0, equalPos).trim();
        String value = equalPos < keyValue.length() - 1 ? keyValue.substring(equalPos + 1).trim() : "";
        return new KeyValue(key, value);
    }

    public KeyValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return '{' + this.key + '=' + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        if (this.key != null ? !this.key.equals(keyValue.key) : keyValue.key != null) {
            return false;
        }
        return this.value != null ? this.value.equals(keyValue.value) : keyValue.value == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public KeyValue removeKeyPrefix(String keyPrefix) {
        String newKey = this.key.substring(keyPrefix.length());
        if (newKey.startsWith(".")) {
            newKey = newKey.substring(1);
        }
        return new KeyValue(newKey, this.value);
    }

    public boolean keyStartsWith(String prefix) {
        return this.key.startsWith(prefix);
    }
}

