/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.github.bingoohuang.FlipTable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.util.BlackcatUtils;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logs {
    public static final boolean HAS_FLIP_TABLE_CONVERTERS = BlackcatUtils.classExists("com.github.bingoohuang.FlipTable");

    public static void logResult(EqlConfig eqlConfig, String sqlClassPath, Object execRet, String sqlId, String tagSqlId) {
        Logger logger = Logs.createLogger(eqlConfig, sqlClassPath, sqlId, tagSqlId, "result");
        if (!(execRet instanceof List)) {
            logger.debug("" + execRet);
            return;
        }
        List list = (List)execRet;
        int size = list.size();
        if (size == 0) {
            logger.debug("total 0 rows");
            return;
        }
        int logMaxRows = EqlUtils.getConfigInt(eqlConfig, "result.log.max", 20);
        if (size > logMaxRows) {
            List logRows = list.subList(0, logMaxRows);
            if (HAS_FLIP_TABLE_CONVERTERS) {
                String table = FlipTable.of(logRows);
                logger.debug("first {}/{} rows: \n{}", new Object[]{logMaxRows, size, table});
            } else {
                logger.debug("first {}/{} rows: {}", new Object[]{logMaxRows, size, logRows});
            }
        } else if (HAS_FLIP_TABLE_CONVERTERS) {
            String table = FlipTable.of((Iterable)list);
            logger.debug("total {} rows: \n{}", (Object)size, (Object)table);
        } else {
            logger.debug("total {} rows: {}", (Object)size, (Object)list);
        }
    }

    public static Logger createLogger(EqlConfig eqlConfig, String sqlClassPath, String sqlId, String tagSqlId, String tag) {
        String loggerPrefix = eqlConfig.getStr("logger.prefix");
        if (S.isBlank(loggerPrefix) || loggerPrefix.equals("auto")) {
            loggerPrefix = "eql";
        }
        if (loggerPrefix.endsWith(".")) {
            loggerPrefix = loggerPrefix.substring(0, loggerPrefix.length() - 1);
        }
        String sqlClassPathNullable = StringUtils.defaultString((String)sqlClassPath, (String)"null");
        String thisSqlId = S.isNotBlank(tagSqlId) ? tagSqlId : sqlId;
        String loggerName = loggerPrefix + '.' + sqlClassPathNullable.replace('/', '.') + '.' + thisSqlId + '.' + tag;
        String stripDollarLoggerName = loggerName.replace('$', '_');
        return LoggerFactory.getLogger((String)stripDollarLoggerName);
    }
}

