/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.codec;

import com.github.bingoohuang.utils.codec.Bytes;
import com.github.bingoohuang.utils.lang.Str;

public class Base64 {
    public static String base64(byte[] bytes) {
        return Base64.base64(bytes, Format.UrlSafe);
    }

    public static String padding(String s) {
        return Str.padding(s, '=', s.length() % 4).toString();
    }

    public static String purify(String s) {
        return Str.removeLastLetters(s, '=').toString();
    }

    public static String base64(String s) {
        return Base64.base64(s, Format.UrlSafe);
    }

    public static String base64(String s, Format format) {
        return Base64.base64(Bytes.bytes(s), format);
    }

    public static String base64(byte[] bytes, Format format) {
        switch (format) {
            case Standard: {
                return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])bytes);
            }
            case UrlSafe: {
                return Base64.purify(org.apache.commons.codec.binary.Base64.encodeBase64URLSafeString((byte[])bytes));
            }
            case Purified: {
                return Base64.purify(org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])bytes));
            }
        }
        return null;
    }

    public static byte[] unBase64(String value) {
        return org.apache.commons.codec.binary.Base64.decodeBase64((String)Base64.padding(value));
    }

    public static String unBase64AsString(String value) {
        return Bytes.string(Base64.unBase64(value));
    }

    public static enum Format {
        Standard,
        UrlSafe,
        Purified;

    }
}

