/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.codec;

import com.github.bingoohuang.utils.codec.BCrypt;
import com.github.bingoohuang.utils.codec.Base64;
import com.github.bingoohuang.utils.codec.Bytes;
import com.github.bingoohuang.utils.codec.Hex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Passwd {
    public static String bcrypt(String originalPassword) {
        return BCrypt.hashpw(originalPassword, BCrypt.gensalt(12));
    }

    public static boolean bcryptMatch(String originalPassword, String securedPasswordHash) {
        return BCrypt.checkpw(originalPassword, securedPasswordHash);
    }

    public static String sha1(String passwordToHash, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            if (salt != null) {
                md.update(Bytes.bytes(salt));
            }
            byte[] bytes = md.digest(passwordToHash.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String generatedPassword = sb.toString();
            return generatedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha256(String passwordToHash, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            if (salt != null) {
                md.update(Bytes.bytes(salt));
            }
            byte[] bytes = md.digest(passwordToHash.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String generatedPassword = sb.toString();
            return generatedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha384(String passwordToHash, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-384");
            if (salt != null) {
                md.update(Bytes.bytes(salt));
            }
            byte[] bytes = md.digest(passwordToHash.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String generatedPassword = sb.toString();
            return generatedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha512(String passwordToHash, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            if (salt != null) {
                md.update(Bytes.bytes(salt));
            }
            byte[] bytes = md.digest(passwordToHash.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String generatedPassword = sb.toString();
            return generatedPassword;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String salt() {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[16];
            sr.nextBytes(salt);
            return Base64.base64(salt);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String pbkdf2(String password, String strSalt) {
        try {
            int iterations = 1000;
            char[] chars = password.toCharArray();
            byte[] salt = Bytes.bytes(strSalt);
            PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return iterations + ":" + Hex.hex(salt) + ":" + Hex.hex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean pbkdf2Match(String originalPassword, String storedPassword) {
        try {
            String[] parts = storedPassword.split(":");
            int iterations = Integer.parseInt(parts[0]);
            byte[] salt = Hex.unHex(parts[1]);
            byte[] hash = Hex.unHex(parts[2]);
            PBEKeySpec spec = new PBEKeySpec(originalPassword.toCharArray(), salt, iterations, hash.length * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] testHash = skf.generateSecret(spec).getEncoded();
            int diff = hash.length ^ testHash.length;
            for (int i = 0; i < hash.length && i < testHash.length; ++i) {
                diff |= hash[i] ^ testHash[i];
            }
            return diff == 0;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

