/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config;

import com.github.bingoohuang.utils.config.Configable;
import com.github.bingoohuang.utils.config.impl.ConfigBuilder;
import com.github.bingoohuang.utils.config.impl.DefConfigSetter;
import com.github.bingoohuang.utils.config.impl.IniConfigable;
import com.github.bingoohuang.utils.config.impl.PropertiesConfigable;
import com.github.bingoohuang.utils.config.impl.PropsConfigable;
import com.github.bingoohuang.utils.config.impl.TableConfigable;
import com.github.bingoohuang.utils.config.utils.ParamsApplyUtils;
import com.github.bingoohuang.utils.lang.ClzPath;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class Config {
    private static Configable impl;

    private static void loadConfigImplementation() {
        Configable defConfig = Config.createConfigable("defconfigdir", "defconfig", null);
        Configable bizConfig = Config.createConfigable("bizconfigdir", "bizconfig", defConfig);
        String configImplementation = bizConfig.getStr("config.implementation");
        if (StringUtils.isEmpty((CharSequence)configImplementation)) {
            impl = bizConfig;
            return;
        }
        impl = Config.loadImpl(configImplementation, bizConfig);
        if (impl instanceof DefConfigSetter) {
            ((DefConfigSetter)((Object)impl)).setDefConfig(defConfig);
        }
    }

    private static Configable loadImpl(String configImplementation, Configable defConfig) {
        return ParamsApplyUtils.createObject(configImplementation, Configable.class);
    }

    private static Configable createConfigable(String configKey, String defConfigDir, Configable defConfig) {
        Resource[] tablesRes;
        Resource[] iniRes;
        Resource[] propsRes;
        Resource[] propertiesRes;
        ConfigBuilder configBuilder = new ConfigBuilder();
        configBuilder.setDefConfig(defConfig);
        String basePackage = defConfigDir;
        Resource envSpaceRes = ClzPath.getResource("envspace.props");
        if (envSpaceRes.exists()) {
            PropsConfigable envSpaceConfig = new PropsConfigable(envSpaceRes);
            basePackage = envSpaceConfig.getStr(configKey, defConfigDir);
            configBuilder.addConfig(envSpaceConfig);
        }
        for (Resource propertieRes : propertiesRes = ClzPath.getResources(basePackage, "**/*.properties")) {
            configBuilder.addConfig(new PropertiesConfigable(propertieRes));
        }
        for (Resource propRes : propsRes = ClzPath.getResources(basePackage, "**/*.props")) {
            configBuilder.addConfig(new PropsConfigable(propRes));
        }
        for (Resource propRes : iniRes = ClzPath.getResources(basePackage, "**/*.ini")) {
            configBuilder.addConfig(new IniConfigable(propRes));
        }
        for (Resource tableRes : tablesRes = ClzPath.getResources(basePackage, "**/*.table")) {
            configBuilder.addConfig(new TableConfigable(tableRes));
        }
        return configBuilder.buildConfig();
    }

    public static boolean exists(String key) {
        return impl.exists(key);
    }

    public static Properties getProperties() {
        return impl.getProperties();
    }

    public static int getInt(String key) {
        return impl.getInt(key);
    }

    public static long getLong(String key) {
        return impl.getLong(key);
    }

    public static boolean getBool(String key) {
        return impl.getBool(key);
    }

    public static float getFloat(String key) {
        return impl.getFloat(key);
    }

    public static double getDouble(String key) {
        return impl.getDouble(key);
    }

    public static String getStr(String key) {
        return impl.getStr(key);
    }

    public static int getInt(String key, int defaultValue) {
        return impl.getInt(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return impl.getLong(key, defaultValue);
    }

    public static boolean getBool(String key, boolean defaultValue) {
        return impl.getBool(key, defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        return impl.getFloat(key, defaultValue);
    }

    public static double getDouble(String key, double defaultValue) {
        return impl.getDouble(key, defaultValue);
    }

    public static String getStr(String key, String defaultValue) {
        return impl.getStr(key, defaultValue);
    }

    public static Configable subset(String prefix) {
        return impl.subset(prefix);
    }

    public static long refreshConfigSet(String prefix) {
        return impl.refreshConfigSet(prefix);
    }

    public static <T> T getBean(String key, Class<T> beanClass) {
        return impl.getBean(key, beanClass);
    }

    public static <T> List<T> getBeans(String key, Class<T> beanClass) {
        return impl.getBeans(key, beanClass);
    }

    public static Configable getConfigImpl() {
        return impl;
    }

    static {
        Config.loadConfigImplementation();
    }
}

