/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config.impl;

import com.alibaba.fastjson.JSON;
import com.github.bingoohuang.utils.config.Configable;
import com.github.bingoohuang.utils.config.ex.ConfigNotFoundException;
import com.github.bingoohuang.utils.config.ex.ConfigValueFormatException;
import com.github.bingoohuang.utils.config.utils.AfterPropertiesSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseConfigable
implements Configable {
    private static Pattern numberPattern = Pattern.compile("(-?[0-9]+\\.[0-9]*|[0-9]*\\.[0-9]+|-?[0-9]+).*");

    @Override
    public int getInt(String key) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ConfigNotFoundException(key + " not found in config system");
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            throw new ConfigValueFormatException(key + "'s value [" + str + "] is not an int");
        }
        String intStr = StringUtils.substringBefore((String)matcher.group(1), (String)".");
        if (StringUtils.isEmpty((CharSequence)intStr)) {
            return 0;
        }
        return Integer.valueOf(intStr);
    }

    @Override
    public long getLong(String key) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ConfigNotFoundException(key + " not found in config system");
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            throw new ConfigValueFormatException(key + "'s value [" + str + "] is not a long");
        }
        String intStr = StringUtils.substringBefore((String)matcher.group(1), (String)".");
        if (StringUtils.isEmpty((CharSequence)intStr)) {
            return 0L;
        }
        return Long.valueOf(intStr);
    }

    @Override
    public boolean getBool(String key) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ConfigNotFoundException(key + " not found in config system");
        }
        return this.toBool(str);
    }

    @Override
    public float getFloat(String key) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ConfigNotFoundException(key + " not found in config system");
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            throw new ConfigValueFormatException(key + "'s value [" + str + "] is not a float");
        }
        return Float.valueOf(matcher.group(1)).floatValue();
    }

    @Override
    public double getDouble(String key) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ConfigNotFoundException(key + " not found in config system");
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            throw new ConfigValueFormatException(key + "'s value [" + str + "] is not a double");
        }
        return Double.valueOf(matcher.group(1));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            return defaultValue;
        }
        String intStr = StringUtils.substringBefore((String)matcher.group(1), (String)".");
        if (StringUtils.isEmpty((CharSequence)intStr)) {
            return defaultValue;
        }
        return Integer.valueOf(intStr);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            return defaultValue;
        }
        String intStr = StringUtils.substringBefore((String)matcher.group(1), (String)".");
        if (StringUtils.isEmpty((CharSequence)intStr)) {
            return defaultValue;
        }
        return Long.valueOf(intStr);
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return this.toBool(str);
    }

    private boolean toBool(String str) {
        return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "on".equalsIgnoreCase(str) || "y".equalsIgnoreCase(str);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            return defaultValue;
        }
        return Float.valueOf(matcher.group(1)).floatValue();
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String str = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        Matcher matcher = numberPattern.matcher(str);
        if (!matcher.matches()) {
            return defaultValue;
        }
        return Double.valueOf(matcher.group(1));
    }

    @Override
    public String getStr(String key, String defaultValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getStr(key), (CharSequence)defaultValue);
    }

    @Override
    public List<String> getKeyPrefixes() {
        ArrayList<String> keyPrefixes = new ArrayList<String>();
        for (Object key : this.getProperties().keySet()) {
            String strKey = (String)key;
            String keyPrefix = StringUtils.substringBefore((String)strKey, (String)".");
            if (keyPrefixes.contains(keyPrefix)) continue;
            keyPrefixes.add(keyPrefix);
        }
        return keyPrefixes;
    }

    @Override
    public <T> T getBean(String key, Class<T> beanClass) {
        String json = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object bean = null;
        try {
            bean = JSON.parseObject((String)json, beanClass);
        }
        catch (Exception ex) {
            throw new ConfigValueFormatException(key + "'s value is not in JSONObject format");
        }
        if (AfterPropertiesSet.class.isAssignableFrom(beanClass)) {
            ((AfterPropertiesSet)bean).afterPropertiesSet();
        }
        return (T)bean;
    }

    @Override
    public <T> List<T> getBeans(String key, Class<T> beanClass) {
        List beans = Lists.newArrayList();
        String json = this.getStr(key);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return beans;
        }
        try {
            if (json.startsWith("[")) {
                beans = JSON.parseArray((String)json, beanClass);
            } else {
                beans.add(JSON.parseObject((String)json, beanClass));
            }
        }
        catch (Exception ex) {
            throw new ConfigValueFormatException(key + "'s value is not in JSONArray format");
        }
        if (AfterPropertiesSet.class.isAssignableFrom(beanClass)) {
            for (Object bean : beans) {
                ((AfterPropertiesSet)bean).afterPropertiesSet();
            }
        }
        return beans;
    }
}

