/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config.impl;

import com.github.bingoohuang.utils.config.ex.ConfigException;
import com.github.bingoohuang.utils.config.impl.DefaultConfigable;
import com.github.bingoohuang.utils.config.impl.PropsReader;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.springframework.core.io.Resource;

public class PropsConfigable
extends DefaultConfigable {
    public PropsConfigable(Resource res) {
        super(PropsConfigable.buildProperties(res));
    }

    private static Properties buildProperties(Resource res) {
        Properties properties;
        PropsReader reader = null;
        Properties props = new Properties();
        try {
            reader = new PropsReader(new InputStreamReader(res.getInputStream(), Charsets.UTF_8));
            while (reader.nextProperty()) {
                if (!props.containsKey(reader.getPropertyName())) {
                    props.put(reader.getPropertyName(), reader.getPropertyValue());
                    continue;
                }
                throw new ConfigException("duplicate key in file " + res.getDescription() + " line " + reader.getLineNumber());
            }
            properties = props;
        }
        catch (IOException ex) {
            try {
                throw new ConfigException("read props file error " + res.getDescription(), ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return properties;
    }
}

