/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config.impl;

import com.github.bingoohuang.utils.config.ex.ConfigException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class PropsReader
extends LineNumberReader {
    static final String COMMENT_CHARS = "#!";
    static final String DEFAULT_SEPARATOR = " = ";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(([\\S&&[^\\\\" + new String(SEPARATORS) + "]]|\\\\.)*)(\\s*(\\s+|[" + new String(SEPARATORS) + "])\\s*)(.*)");
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private static final int IDX_KEY = 1;
    private static final int IDX_VALUE = 5;
    private static final int IDX_SEPARATOR = 3;
    private String propertyName;
    private String propertyValue;

    public PropsReader(Reader reader) {
        super(reader);
    }

    private static boolean checkCombineLines(String line) {
        return PropsReader.countTrailingBS(line) % 2 != 0;
    }

    private static String[] doParseProperty(String line) {
        Matcher matcher = PROPERTY_PATTERN.matcher(line);
        String[] result = new String[]{"", "", ""};
        if (matcher.matches()) {
            result[0] = matcher.group(1).trim();
            result[1] = matcher.group(5).trim();
            result[2] = matcher.group(3);
        }
        return result;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    private static int countTrailingBS(String line) {
        int bsCount = 0;
        for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
            ++bsCount;
        }
        return bsCount;
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                    continue;
                }
                if (ch == '\'') {
                    out.append('\'');
                    continue;
                }
                if (ch == '\"') {
                    out.append('\"');
                    continue;
                }
                if (ch == 'r') {
                    out.append('\r');
                    continue;
                }
                if (ch == 'f') {
                    out.append('\f');
                    continue;
                }
                if (ch == 't') {
                    out.append('\t');
                    continue;
                }
                if (ch == 'n') {
                    out.append('\n');
                    continue;
                }
                if (ch == 'b') {
                    out.append('\b');
                    continue;
                }
                if (ch == delimiter) {
                    out.append('\\').append(delimiter);
                    continue;
                }
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    public String readProperty() throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        while (true) {
            if ((line = this.readLine()) == null) {
                return null;
            }
            if (PropsReader.isCommentLine(line)) continue;
            if (!PropsReader.checkCombineLines(line = line.trim())) break;
            line = line.substring(0, line.length() - 1);
            buffer.append(line);
        }
        buffer.append(line);
        return buffer.toString();
    }

    public boolean nextProperty() throws IOException {
        String line = this.readProperty();
        if (line == null) {
            return false;
        }
        this.parseProperty(line);
        return true;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    protected void parseProperty(String line) {
        String[] property = PropsReader.doParseProperty(line);
        this.initPropertyName(property[0]);
        this.initPropertyValue(property[1]);
    }

    protected void initPropertyName(String name) {
        this.propertyName = StringEscapeUtils.unescapeJava((String)name);
    }

    protected void initPropertyValue(String value) {
        this.propertyValue = PropsReader.unescapeJava(value, ',');
    }
}

