/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config.impl;

import com.github.bingoohuang.utils.config.ex.ConfigException;
import com.github.bingoohuang.utils.config.impl.ConfigTable;
import com.github.bingoohuang.utils.config.impl.DefaultConfigable;
import com.github.bingoohuang.utils.config.impl.TableReader;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.springframework.core.io.Resource;

public class TableConfigable
extends DefaultConfigable {
    public TableConfigable(Resource res) {
        super(TableConfigable.buildProperties(res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties buildProperties(Resource res) {
        Properties props = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(res.getInputStream(), Charsets.UTF_8);
            TableReader tableReader = new TableReader(reader);
            List<ConfigTable> tables = tableReader.getTables();
            for (ConfigTable table : tables) {
                String tableName = table.getTableName();
                if (props.containsKey(tableName)) {
                    throw new ConfigException("duplicate key [" + tableName + "] in file...");
                }
                props.put(tableName, table);
            }
        }
        catch (IOException iOException) {
            Closeables.closeQuietly(reader);
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Reader)reader);
        return props;
    }
}

