/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.config.impl;

import com.github.bingoohuang.utils.config.ex.ConfigException;
import com.github.bingoohuang.utils.config.impl.CSVLineReader;
import com.github.bingoohuang.utils.config.impl.ConfigCell;
import com.github.bingoohuang.utils.config.impl.ConfigRow;
import com.github.bingoohuang.utils.config.impl.ConfigTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TableReader {
    private static final String COMMENT = "#";
    private static final String ROW_PREFIX = "#!";
    private List<ConfigTable> tables = new ArrayList<ConfigTable>();
    private String tableName = "";
    private Set<Integer> rowKeyIndex = new HashSet<Integer>();
    private ConfigTable configTable = null;
    private String[] cols = null;

    public TableReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.dealEachLine(bufferedReader);
        this.tables.add(this.configTable);
    }

    private static boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith(COMMENT) && !line.startsWith(ROW_PREFIX);
    }

    private static boolean isRowCols(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith(ROW_PREFIX);
    }

    private static String generateTableNameFromLine(String line) {
        String trimLine = StringUtils.trim((String)line);
        return StringUtils.trim((String)StringUtils.substring((String)trimLine, (int)1, (int)(trimLine.length() - 1)));
    }

    private static boolean isTableName(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("[") && line.endsWith("]");
    }

    private void dealEachLine(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        while (line != null) {
            if (!StringUtils.isEmpty((CharSequence)line) && !TableReader.isCommentLine(line)) {
                if (TableReader.isTableName(line = StringUtils.trim((String)line))) {
                    this.doWhenIsTableName(line);
                } else if (TableReader.isRowCols(line)) {
                    this.doWhenIsRowCols(line);
                } else {
                    this.doWhenIsData(line);
                }
            }
            line = bufferedReader.readLine();
        }
    }

    private void doWhenIsData(String line) {
        String[] splitLine = new CSVLineReader().parseLine(line);
        ConfigRow row = new ConfigRow();
        String rowKey = "";
        for (int i = 0; i < splitLine.length; ++i) {
            String value = StringUtils.trim((String)splitLine[i]);
            if (this.rowKeyIndex.contains(i)) {
                rowKey = rowKey + value;
            }
            ConfigCell cell = new ConfigCell(this.cols[i], value);
            row.addCell(cell);
        }
        if (StringUtils.isEmpty((CharSequence)rowKey)) {
            throw new ConfigException("table [" + this.tableName + "] config has no rowKey!");
        }
        row.setRowKey(rowKey);
        this.configTable.addRow(row);
    }

    private void doWhenIsRowCols(String line) {
        String[] splitLine = StringUtils.split((String)StringUtils.substring((String)line, (int)2, (int)line.length()), (char)',');
        this.cols = new String[splitLine.length];
        for (int i = 0; i < splitLine.length; ++i) {
            String str = StringUtils.trim((String)splitLine[i]);
            if (StringUtils.endsWith((CharSequence)str, (CharSequence)"*")) {
                str = StringUtils.substringBeforeLast((String)str, (String)"*");
                this.rowKeyIndex.add(i);
            }
            this.cols[i] = str;
        }
    }

    private void doWhenIsTableName(String line) {
        if (null != this.configTable) {
            this.tables.add(this.configTable);
        }
        this.tableName = TableReader.generateTableNameFromLine(line);
        this.configTable = new ConfigTable(this.tableName);
        this.rowKeyIndex.clear();
    }

    public List<ConfigTable> getTables() {
        return this.tables;
    }

    public void setTables(List<ConfigTable> tables) {
        this.tables = tables;
    }
}

