/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.crypto;

import com.github.bingoohuang.utils.codec.Base64;
import com.github.bingoohuang.utils.codec.Bytes;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AesIV {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static String encrypt(String value, String key) {
        String iv = AesIV.randomIV();
        String encrypt = AesIV.encrypt(value, key, iv);
        return iv + ":" + encrypt;
    }

    public static String decrypt(String value, String key) {
        String iv = StringUtils.substringBefore((String)value, (String)":");
        String content = StringUtils.substringAfter((String)value, (String)":");
        return AesIV.decrypt(content, key, iv);
    }

    public static String encrypt(String value, String key, String iv) {
        SecretKeySpec skeySpec = new SecretKeySpec(Base64.unBase64(key), KEY_ALGORITHM);
        return AesIV.encrypt(value, skeySpec, iv);
    }

    public static String decrypt(String value, String key, String iv) {
        SecretKeySpec skeySpec = new SecretKeySpec(Base64.unBase64(key), KEY_ALGORITHM);
        return AesIV.decrypt(value, skeySpec, iv);
    }

    public static String randomIV() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return Base64.base64(iv);
    }

    public static String decrypt(String value, Key key, String iv) {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(Base64.unBase64(iv));
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, key, ivParameterSpec);
            byte[] decrypted = cipher.doFinal(Base64.unBase64(value));
            return Bytes.string(decrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String value, Key key, String iv) {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(Base64.unBase64(iv));
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, key, ivParameterSpec);
            byte[] encrypted = cipher.doFinal(Bytes.bytes(value));
            return Base64.base64(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String key = "uzTnFINhcCOYmzwdI9VkXA";
        System.out.println(AesIV.encrypt("hello world, it's me, bingoo huang", key));
        System.out.println(AesIV.encrypt("hello world, it's me, holly wolf", key));
        System.out.println(AesIV.decrypt("Bv-RMDpEL-h9C9tYSDBavA:KZpF4UjfrHjxQ_321-P59Yn46ATCJ54hyf_BTlgotbfSKDD7TiXoRonf36XlutCJ", key));
        System.out.println(AesIV.decrypt("osVFk4Ct14StOhrgF-UJdg:LJVndkjwCmj7pD1mANPejNMG0qL4eXeMg7w0ofH_7zMPsKnQbykci6MZEO-tlDVR", key));
    }
}

