/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.crypto;

import com.github.bingoohuang.utils.codec.Base64;
import com.github.bingoohuang.utils.lang.Closer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSA {
    public static final String KEY_ALGORITHMS = "RSA";
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    public static String sign(String plainText, String privateKey, String plainTextCharset) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(RSA.generatePrivateKey(privateKey));
            signature.update(plainText.getBytes(plainTextCharset));
            return Base64.base64(signature.sign(), Base64.Format.Standard);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(String plainText, String sign, String publicKey, String plainTextCharset) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(RSA.generatePublicKey(publicKey));
            signature.update(plainText.getBytes(plainTextCharset));
            return signature.verify(Base64.unBase64(sign));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String cipherText, String privateKey, String cipherTextCharset) throws IOException {
        String string;
        ByteArrayInputStream ins = null;
        ByteArrayOutputStream writer = null;
        try {
            int bufl;
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHMS);
            cipher.init(2, RSA.generatePrivateKey(privateKey));
            ins = new ByteArrayInputStream(Base64.unBase64(cipherText));
            writer = new ByteArrayOutputStream();
            byte[] buf = new byte[128];
            while ((bufl = ins.read(buf)) != -1) {
                byte[] block = null;
                if (buf.length == bufl) {
                    block = buf;
                } else {
                    block = new byte[bufl];
                    for (int i = 0; i < bufl; ++i) {
                        block[i] = buf[i];
                    }
                }
                writer.write(cipher.doFinal(block));
            }
            string = new String(writer.toByteArray(), cipherTextCharset);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closer.closeQuietly(ins, writer);
                throw throwable;
            }
        }
        Closer.closeQuietly(ins, writer);
        return string;
    }

    public static PrivateKey generatePrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance(KEY_ALGORITHMS).generatePrivate(new PKCS8EncodedKeySpec(Base64.unBase64(privateKey)));
    }

    public static PublicKey generatePublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance(KEY_ALGORITHMS).generatePublic(new X509EncodedKeySpec(Base64.unBase64(publicKey)));
    }
}

