/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.joor;

import com.github.bingoohuang.utils.joor.ReflectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;

public class Reflect {
    private final Object object;
    private final boolean isClass;

    public static Reflect on(String name) throws ReflectException {
        return Reflect.on(Reflect.forName(name));
    }

    public static Reflect on(Class<?> clazz) {
        return new Reflect(clazz);
    }

    public static Reflect on(Object object) {
        return new Reflect(object);
    }

    private Reflect(Class<?> type) {
        this.object = type;
        this.isClass = true;
    }

    private Reflect(Object object) {
        this.object = object;
        this.isClass = false;
    }

    public <T> T get() {
        return (T)this.object;
    }

    public Reflect set(String name, Object value) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            field.set(this.object, Reflect.unwrap(value));
            return this;
        }
        catch (Exception e1) {
            boolean accessible = true;
            Field field = null;
            try {
                field = this.type().getDeclaredField(name);
                accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(this.object, Reflect.unwrap(value));
                Reflect reflect = this;
                return reflect;
            }
            catch (Exception e2) {
                throw new ReflectException(e2);
            }
            finally {
                if (field != null && !accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }

    public Reflect set(Field field, Object value) throws ReflectException {
        try {
            field.set(this.object, Reflect.unwrap(value));
            return this;
        }
        catch (Exception e1) {
            boolean accessible = true;
            try {
                accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(this.object, Reflect.unwrap(value));
                Reflect reflect = this;
                return reflect;
            }
            catch (Exception e2) {
                throw new ReflectException(e2);
            }
            finally {
                if (field != null && !accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }

    public <T> T get(String name) throws ReflectException {
        return this.field(name).get();
    }

    public <T> T get(Field field) throws ReflectException {
        boolean accessible = true;
        try {
            accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            T t = Reflect.on(field.get(this.object)).get();
            return t;
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
    }

    public Reflect field(String name) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            return Reflect.on(field.get(this.object));
        }
        catch (Exception e1) {
            Field field = null;
            boolean accessible = true;
            try {
                field = this.type().getDeclaredField(name);
                accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                Reflect reflect = Reflect.on(field.get(this.object));
                return reflect;
            }
            catch (Exception e2) {
                throw new ReflectException(e2);
            }
            finally {
                if (field != null && !accessible) {
                    field.setAccessible(false);
                }
            }
        }
    }

    public Map<String, Reflect> fields() {
        LinkedHashMap<String, Reflect> result = new LinkedHashMap<String, Reflect>();
        for (Field field : this.type().getFields()) {
            if (!(!this.isClass ^ Modifier.isStatic(field.getModifiers()))) continue;
            String name = field.getName();
            result.put(name, this.field(name));
        }
        return result;
    }

    public Reflect call(String name) throws ReflectException {
        return this.call(name, new Object[0]);
    }

    public Reflect call(String name, Object ... args) throws ReflectException {
        Class<?>[] types = Reflect.types(args);
        try {
            Method method = this.type().getMethod(name, types);
            return Reflect.on(method, this.object, args);
        }
        catch (NoSuchMethodException e) {
            for (Method method : this.type().getMethods()) {
                if (!method.getName().equals(name) || !this.match(method.getParameterTypes(), types)) continue;
                return Reflect.on(method, this.object, args);
            }
            throw new ReflectException(e);
        }
    }

    public Reflect create() throws ReflectException {
        return this.create(new Object[0]);
    }

    public Reflect create(Object ... args) throws ReflectException {
        Class<?>[] types = Reflect.types(args);
        try {
            Constructor<?> constructor = this.type().getConstructor(types);
            return Reflect.on(constructor, args);
        }
        catch (NoSuchMethodException e) {
            for (Constructor<?> constructor : this.type().getConstructors()) {
                if (!this.match(constructor.getParameterTypes(), types)) continue;
                return Reflect.on(constructor, args);
            }
            throw new ReflectException(e);
        }
    }

    public <P> P as(Class<P> proxyType) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return Reflect.on(Reflect.this.object).call(method.getName(), args).get();
            }
        };
        return (P)Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, handler);
    }

    private boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i = 0; i < actualTypes.length; ++i) {
                if (Reflect.wrapper(declaredTypes[i]).isAssignableFrom(Reflect.wrapper(actualTypes[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Reflect) {
            return this.object.equals(((Reflect)obj).get());
        }
        return false;
    }

    public String toString() {
        return this.object.toString();
    }

    private static Reflect on(Constructor<?> constructor, Object ... args) throws ReflectException {
        try {
            return Reflect.on(constructor.newInstance(args));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private static Reflect on(Method method, Object object, Object ... args) throws ReflectException {
        boolean accessible = method.isAccessible();
        try {
            if (!accessible) {
                method.setAccessible(true);
            }
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(object, args);
                Reflect reflect = Reflect.on(object);
                return reflect;
            }
            Reflect reflect = Reflect.on(method.invoke(object, args));
            return reflect;
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
        finally {
            if (!accessible) {
                method.setAccessible(false);
            }
        }
    }

    private static Object unwrap(Object object) {
        if (object instanceof Reflect) {
            return ((Reflect)object).get();
        }
        return object;
    }

    private static Class<?>[] types(Object ... values) {
        if (values == null) {
            return new Class[0];
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getClass();
        }
        return result;
    }

    private static Class<?> forName(String name) throws ReflectException {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public Class<?> type() {
        if (this.isClass) {
            return (Class)this.object;
        }
        return this.object.getClass();
    }

    private static Class<?> wrapper(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        return type;
    }
}

