/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.joou;

import com.github.bingoohuang.utils.joou.UNumber;

public final class UByte
extends UNumber
implements Comparable<UByte> {
    private static final long serialVersionUID = -6821055240959745390L;
    public static final short MIN_VALUE = 0;
    public static final short MAX_VALUE = 255;
    private final short value;

    public static UByte valueOf(String value) throws NumberFormatException {
        return new UByte(value);
    }

    public static UByte valueOf(byte value) {
        return new UByte(value);
    }

    public UByte(short value) throws NumberFormatException {
        this.value = value;
        this.rangeCheck();
    }

    public UByte(byte value) {
        this.value = (short)(value & 0xFF);
    }

    public UByte(String value) throws NumberFormatException {
        this.value = Short.parseShort(value);
        this.rangeCheck();
    }

    private void rangeCheck() throws NumberFormatException {
        if (this.value < 0 || this.value > 255) {
            throw new NumberFormatException("Value is out of range : " + this.value);
        }
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Short.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UByte) {
            return this.value == ((UByte)obj).value;
        }
        return false;
    }

    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    @Override
    public int compareTo(UByte o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }
}

