/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.joou;

import com.github.bingoohuang.utils.joou.UNumber;

public final class UInteger
extends UNumber
implements Comparable<UInteger> {
    private static final long serialVersionUID = -6821055240959745390L;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    private final long value;

    public static UInteger valueOf(String value) throws NumberFormatException {
        return new UInteger(value);
    }

    public static UInteger valueOf(int value) {
        return new UInteger(value);
    }

    public UInteger(long value) throws NumberFormatException {
        this.value = value;
        this.rangeCheck();
    }

    public UInteger(int value) {
        this.value = (long)value & 0xFFFFFFFFL;
    }

    public UInteger(String value) throws NumberFormatException {
        this.value = Long.parseLong(value);
        this.rangeCheck();
    }

    private void rangeCheck() throws NumberFormatException {
        if (this.value < 0L || this.value > 0xFFFFFFFFL) {
            throw new NumberFormatException("Value is out of range : " + this.value);
        }
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UInteger) {
            return this.value == ((UInteger)obj).value;
        }
        return false;
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    @Override
    public int compareTo(UInteger o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }
}

