/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.lang;

import com.github.bingoohuang.utils.lang.Clz;
import java.io.Closeable;
import java.lang.reflect.Method;

public class Closer {
    private Closer() {
    }

    public static void closeQuietly(Object ... objs) {
        for (Object obj : objs) {
            Closer.closeQuietly(obj);
        }
    }

    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            return;
        }
        Method method = Clz.getMethod(obj.getClass(), "close");
        if (method != null && method.getParameterTypes().length == 0) {
            Clz.invokeQuietly(obj, method);
        }
    }
}

