/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class Clz {
    public static boolean isAssignable(Class<?> fromClass, Class<?> ... toClasses) {
        for (Class<?> toClass : toClasses) {
            if (!ClassUtils.isAssignable(fromClass, toClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static Class<?> findClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <T> Class<T> loadClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            return Clz.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Method getMethod(Class<? extends Object> class1, String methodName) {
        try {
            return class1.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeQuietly(Object target, Method m) {
        block4: {
            try {
                return m.invoke(target, new Object[0]);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                if (!(e.getTargetException() instanceof RuntimeException)) break block4;
                throw (RuntimeException)e.getTargetException();
            }
        }
        return null;
    }
}

