/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.lang;

import com.github.bingoohuang.utils.lang.Clz;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClzPath {
    public static String toStr(String resClasspath) {
        return ClzPath.toStr(resClasspath, Charsets.UTF_8);
    }

    public static List<String> toLines(String resClasspath) {
        return ClzPath.toLines(resClasspath, Charsets.UTF_8);
    }

    public static List<String> toLines(String resClasspath, Charset charset) {
        InputStream is = ClzPath.toInputStream(resClasspath);
        try {
            List list = CharStreams.readLines((Readable)new InputStreamReader(is, charset));
            return list;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    public static String toStr(String resClasspath, Charset charset) {
        InputStream is = ClzPath.toInputStream(resClasspath);
        try {
            String string = CharStreams.toString((Readable)new InputStreamReader(is, charset));
            return string;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    public static InputStream toInputStream(String resClasspath) {
        InputStream res = ClzPath.class.getClassLoader().getResourceAsStream(resClasspath);
        if (res == null) {
            throw new RuntimeException(resClasspath + " does not exist");
        }
        return res;
    }

    public static Reader toReader(String resClasspath) {
        InputStream inputStream = ClzPath.toInputStream(resClasspath);
        return new InputStreamReader(inputStream, Charsets.UTF_8);
    }

    public static List<Class<?>> getClasses(String basePackage, Predicate<Class<?>> predicate) {
        return ClzPath.getClasses(basePackage, "**/*.class", predicate, null);
    }

    public static List<Class<?>> getClasses(String basePackage, String pattern, Predicate<Class<?>> classPredicate, Predicate<String> classNamePredicate) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metaFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        try {
            String packageSearchPath = "classpath*:" + ClzPath.resolveBasePackage(basePackage) + "/" + pattern;
            Resource[] resources = resolver.getResources(packageSearchPath);
            ArrayList clazzArr = new ArrayList();
            for (Resource res : resources) {
                Class<?> clazz;
                if (!res.isReadable()) continue;
                MetadataReader metadataReader = metaFactory.getMetadataReader(res);
                String className = metadataReader.getClassMetadata().getClassName();
                if (classNamePredicate != null && !classNamePredicate.apply((Object)className) || (clazz = Clz.findClass(className)) == null || !classPredicate.apply(clazz)) continue;
                clazzArr.add(clazz);
            }
            return clazzArr;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    public static List<Class<?>> getSubClasses(String basePackage, Class<?> superClass) {
        return ClzPath.getSubClasses(basePackage, "**/*.class", superClass);
    }

    public static List<Class<?>> getSubClasses(String basePackage, String pattern, Class<?> superClass) {
        return ClzPath.getClasses(basePackage, pattern, new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return false;
            }
        }, null);
    }

    public static List<Class<?>> getAnnotatedClasses(String basePackage, Class<? extends Annotation> annClass, Class<?> ... excludesClasses) {
        return ClzPath.getAnnotatedClasses(basePackage, "**/*.class", annClass, excludesClasses);
    }

    public static List<Class<?>> getAnnotatedClasses(String basePackage, String pattern, final Class<? extends Annotation> annClass, final Class<?> ... excludesClasses) {
        return ClzPath.getClasses(basePackage, pattern, new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isAnnotationPresent(annClass);
            }
        }, (Predicate<String>)Predicates.not((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                for (Class class1 : excludesClasses) {
                    if (!input.equals(class1.getName())) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public static Resource getResource(String classPathPattern) {
        return new ClassPathResource(classPathPattern);
    }

    public static Resource[] getResources(String basePackage, String classPathPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            String packageSearchPath = "classpath*:" + ClzPath.resolveBasePackage(basePackage) + "/" + classPathPattern;
            return resolver.getResources(packageSearchPath);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

