/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.lang;

import com.github.bingoohuang.utils.lang.Jdbc;
import com.google.common.base.CaseFormat;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.objenesis.ObjenesisStd;

public class DefaultBeanMapper<T>
implements Jdbc.BeanMapper<T> {
    private final Class<T> beanClass;

    public DefaultBeanMapper(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public T map(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashMap map = Maps.newHashMap();
        for (int i = 1; i <= columnCount; ++i) {
            Object object = rs.getObject(i);
            String columnLabel = this.allUpperToLower(metaData.getColumnLabel(i));
            map.put(columnLabel, object);
            map.put(this.underscoreToCamel(columnLabel), object);
            String columnName = this.allUpperToLower(metaData.getColumnName(i));
            map.put(columnName, object);
            map.put(this.underscoreToCamel(columnName), object);
        }
        Object instance = new ObjenesisStd().getInstantiatorOf(this.beanClass).newInstance();
        try {
            BeanUtils.populate((Object)instance, (Map)map);
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        return (T)instance;
    }

    private String allUpperToLower(String str) {
        return this.withoutLowercaseLetters(str) ? str.toLowerCase() : str;
    }

    private boolean withoutLowercaseLetters(String str) {
        int ii = str.length();
        for (int i = 0; i < ii; ++i) {
            char ch = str.charAt(i);
            if (ch < 'a' || ch > 'z') continue;
            return false;
        }
        return true;
    }

    private String underscoreToCamel(String str) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, str);
    }
}

