/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.lang;

import java.util.HashSet;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Substituters {
    public static final String DEF_HOLDER_PREFIX = "${";
    public static final String DEF_HOLDER_SUFFIX = "}";
    public static final int SYS_PROPS_MODE_FALLBACK = 1;
    public static final int SYS_PROPS_MODE_OVERRIDE = 2;
    private static final int DEF_HOLDER_PREFIX_LEN = "${".length();
    private static final int DEF_HOLDER_SUFFIX_LEN = "}".length();
    private static Logger log = LoggerFactory.getLogger(Substituters.class);

    public static String parse(String strVal) {
        HashSet<String> visitedHolders = new HashSet<String>();
        return Substituters.parse(strVal, null, visitedHolders, false);
    }

    public static String parse(String strVal, Object props) {
        HashSet<String> visitedHolders = new HashSet<String>();
        return Substituters.parse(strVal, props, visitedHolders, false);
    }

    public static String parse(String strVal, Object sub, Object props) {
        HashSet<String> visitedHolders = new HashSet<String>();
        return Substituters.parse(strVal, sub, props, visitedHolders, false);
    }

    private static String parse(String strVal, Object sub, Object props, Set<String> visitedHolders, boolean ignoreBadHolders) {
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(DEF_HOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = Substituters.findHolderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String holder = buf.substring(startIndex + DEF_HOLDER_PREFIX_LEN, endIndex);
                String defValue = null;
                int defIndex = StringUtils.lastIndexOf((CharSequence)holder, (CharSequence)":");
                if (defIndex >= 0) {
                    defValue = StringUtils.trim((String)holder.substring(defIndex + 1));
                    holder = StringUtils.trim((String)holder.substring(0, defIndex));
                }
                if (!visitedHolders.add(holder)) {
                    throw new RuntimeException("Circular PlaceHolder reference '" + holder + "' in property definitions");
                }
                String propVal = Substituters.resolveHolder(holder = Substituters.parse(holder, props, visitedHolders, ignoreBadHolders), sub, props, 1, defValue);
                if (propVal != null) {
                    propVal = Substituters.parse(propVal, props, visitedHolders, ignoreBadHolders);
                    buf.replace(startIndex, endIndex + DEF_HOLDER_SUFFIX_LEN, propVal);
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, startIndex + propVal.length());
                } else if (ignoreBadHolders) {
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, endIndex + DEF_HOLDER_SUFFIX_LEN);
                } else {
                    throw new RuntimeException("Could not resolve Placeholder '" + holder + "'");
                }
                visitedHolders.remove(holder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private static String resolveHolder(String holder, Object sub, Object props, int sysPropsMode, String defaultValue) {
        String propVal = null;
        if (sysPropsMode == 2) {
            propVal = Substituters.resolveSystemProperty(holder);
        }
        if (propVal == null) {
            propVal = Substituters.resolveHolder(holder, props, defaultValue);
        }
        if (propVal == null && sysPropsMode == 1) {
            propVal = Substituters.resolveSystemProperty(holder);
        }
        if (propVal == null) {
            propVal = Substituters.resolveHolder(holder, sub, defaultValue);
        }
        return propVal;
    }

    public static String parse(String strVal, boolean ignoreBadHolders) {
        HashSet<String> visitedHolders = new HashSet<String>();
        return Substituters.parse(strVal, null, visitedHolders, ignoreBadHolders);
    }

    public static String parse(String strVal, Object props, Set<String> visitedHolders, boolean ignoreBadHolders) {
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(DEF_HOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = Substituters.findHolderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String holder = buf.substring(startIndex + DEF_HOLDER_PREFIX_LEN, endIndex);
                String defValue = null;
                int defIndex = StringUtils.lastIndexOf((CharSequence)holder, (CharSequence)":");
                if (defIndex >= 0) {
                    defValue = StringUtils.trim((String)holder.substring(defIndex + 1));
                    holder = StringUtils.trim((String)holder.substring(0, defIndex));
                }
                if (!visitedHolders.add(holder)) {
                    throw new RuntimeException("Circular PlaceHolder reference '" + holder + "' in property definitions");
                }
                String propVal = Substituters.resolveHolder(holder = Substituters.parse(holder, props, visitedHolders, ignoreBadHolders), props, 1, defValue);
                if (propVal != null) {
                    propVal = Substituters.parse(propVal, props, visitedHolders, ignoreBadHolders);
                    buf.replace(startIndex, endIndex + DEF_HOLDER_SUFFIX_LEN, propVal);
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, startIndex + propVal.length());
                } else if (ignoreBadHolders) {
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, endIndex + DEF_HOLDER_SUFFIX_LEN);
                } else {
                    throw new RuntimeException("Could not resolve Placeholder '" + holder + "'");
                }
                visitedHolders.remove(holder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private static int findHolderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + DEF_HOLDER_PREFIX_LEN;
        int withinNestedHolder = 0;
        while (index < buf.length()) {
            if (Substituters.substringMatch(buf, index, DEF_HOLDER_SUFFIX)) {
                if (withinNestedHolder > 0) {
                    --withinNestedHolder;
                    index += DEF_HOLDER_SUFFIX_LEN;
                    continue;
                }
                return index;
            }
            if (Substituters.substringMatch(buf, index, DEF_HOLDER_PREFIX)) {
                ++withinNestedHolder;
                index += DEF_HOLDER_PREFIX_LEN;
                continue;
            }
            ++index;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    private static String resolveHolder(String holder, Object props, int sysPropsMode, String defaultValue) {
        String propVal = null;
        if (sysPropsMode == 2) {
            propVal = Substituters.resolveSystemProperty(holder);
        }
        if (propVal == null) {
            propVal = Substituters.resolveHolder(holder, props, defaultValue);
        }
        if (propVal == null && sysPropsMode == 1) {
            propVal = Substituters.resolveSystemProperty(holder);
        }
        return propVal;
    }

    protected static String resolveHolder(String holder, Object props, String defaultValue) {
        if (props != null) {
            Object value = Substituters.ognlGetValue(holder, props);
            if (value != null) {
                return "" + value;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static Object ognlGetValue(String holder, Object props) {
        try {
            return Ognl.getValue((String)holder, (Object)props);
        }
        catch (OgnlException e) {
            log.debug("", (Throwable)e);
            return null;
        }
    }

    private static String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

