/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.net;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class Cookies {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String domain;
    private String name;

    public Cookies(HttpServletRequest request, HttpServletResponse response, String domain, String name) {
        this.request = request;
        this.response = response;
        this.domain = domain;
        this.name = name;
    }

    public Cookies(HttpServletResponse response, String domain, String name) {
        this(null, response, domain, name);
    }

    public Cookies(HttpServletResponse response, String name) {
        this(null, response, null, name);
    }

    public Cookies(HttpServletRequest request, String name) {
        this(request, null, null, name);
    }

    public String getCookie() {
        if (this.request.getCookies() == null) {
            return "";
        }
        for (Cookie cookie : this.request.getCookies()) {
            if (!this.name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public Cookie addCookie(String value) {
        return this.addCookie(value, -1, HttpOnly.OFF, Secure4Https.OFF);
    }

    public Cookie addCookie(String value, int expire, TimeUnit timeUnit) {
        return this.addCookie(value, (int)timeUnit.toSeconds(expire), HttpOnly.OFF, Secure4Https.OFF);
    }

    public Cookie addCookie(String value, int maxSeconds, HttpOnly httpOnly, Secure4Https secure4Https) {
        Cookie cookie = new Cookie(this.name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxSeconds);
        cookie.setHttpOnly(httpOnly == HttpOnly.ON);
        cookie.setSecure(secure4Https == Secure4Https.ON);
        if (StringUtils.isNotEmpty((CharSequence)this.domain)) {
            cookie.setDomain(this.domain);
        }
        this.response.addCookie(cookie);
        return cookie;
    }

    public void delCookie() {
        this.addCookie("", 0, HttpOnly.OFF, Secure4Https.OFF);
    }

    public static enum Secure4Https {
        ON,
        OFF;

    }

    public static enum HttpOnly {
        ON,
        OFF;

    }
}

