/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.net;

import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class Email {
    private final String emailHost;
    private final String emailUserName;
    private final String emailPassword;
    private final String emailSendFrom;
    private final boolean exceptionSilent;
    Logger log = LoggerFactory.getLogger(Email.class);

    public Email(String emailHost, String emailUserName, String emailPassword, String emailSendFrom, boolean exceptionSilent) {
        this.emailHost = emailHost;
        this.emailUserName = emailUserName;
        this.emailPassword = emailPassword;
        this.emailSendFrom = emailSendFrom;
        this.exceptionSilent = exceptionSilent;
    }

    public void emailTo(String to, String subject, String htmlContent) {
        JavaMailSenderImpl senderImpl = new JavaMailSenderImpl();
        senderImpl.setHost(this.emailHost);
        senderImpl.setUsername(this.emailUserName);
        senderImpl.setPassword(this.emailPassword);
        Properties prop = new Properties();
        prop.put("mail.smtp.auth", "true");
        prop.put("mail.smtp.timeout", "25000");
        senderImpl.setJavaMailProperties(prop);
        try {
            MimeMessage mimeMessage = this.createMimeMessage(senderImpl, to, subject, htmlContent);
            senderImpl.send(mimeMessage);
        }
        catch (Exception e) {
            if (!this.exceptionSilent) {
                throw new RuntimeException(e);
            }
            this.log.error("email to {} with subject {} exception", new Object[]{to, subject, e});
        }
    }

    private MimeMessage createMimeMessage(JavaMailSenderImpl senderImpl, String to, String subject, String htmlContent) throws MessagingException {
        MimeMessage mailMessage = senderImpl.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "UTF-8");
        messageHelper.setFrom(this.emailSendFrom);
        messageHelper.setTo(to);
        messageHelper.setSubject(subject);
        messageHelper.setText(htmlContent, true);
        return mailMessage;
    }
}

