/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.net;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class FileUploader {
    String boundary;
    HttpURLConnection httpConn;
    OutputStream out;

    public FileUploader(String requestURL) {
        try {
            URL url = new URL(requestURL);
            this.httpConn = (HttpURLConnection)url.openConnection();
            this.boundary = "---" + System.currentTimeMillis() + "---";
            this.httpConn.setDoOutput(true);
            this.httpConn.setDoInput(true);
            this.httpConn.setUseCaches(false);
            this.httpConn.setRequestMethod("POST");
            this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            this.out = new DataOutputStream(this.httpConn.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addHeader(String name, String value) throws IOException {
        this.out.write((name + ": " + value + "\r\n").getBytes());
    }

    public void addFilePart(File file) throws IOException {
        this.addFilePart(file.getName(), new FileInputStream(file));
    }

    public void addFilePart(String fileName, InputStream inputStream) {
        String preparePart = this.preparePart(fileName);
        try {
            this.out.write(preparePart.getBytes());
            this.copyStream(inputStream);
            this.out.write("\r\n".getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String preparePart(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append("--" + this.boundary + "\r\n");
        sb.append("Content-Disposition: form-data;name=\"" + fileName + "\";filename=\"" + fileName + "\"\r\n");
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        sb.append("Content-Type:" + contentType + "\r\n\r\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(InputStream is) throws IOException {
        DataInputStream in = new DataInputStream(is);
        try {
            int bytes;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                this.out.write(bufferOut, 0, bytes);
            }
        }
        finally {
            in.close();
            is.close();
        }
    }

    public String finish() {
        byte[] end_data = ("\r\n--" + this.boundary + "--\r\n").getBytes();
        int status = 0;
        try {
            this.out.write(end_data);
            this.out.flush();
            this.out.close();
            status = this.httpConn.getResponseCode();
            if (status == 200) {
                InputStream inputStream = this.httpConn.getInputStream();
                String response = this.readInputStreamToString(inputStream);
                this.httpConn.disconnect();
                return response.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Server returned non-OK status: " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStreamToString(InputStream inputStream) throws IOException {
        StringBuilder response = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return response.toString();
    }
}

