/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.net;

import com.github.bingoohuang.utils.lang.Closer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Http {
    public static void respondJSON(HttpServletResponse rsp, String json) {
        Http.responseContent(rsp, json, "application/json", "UTF-8");
    }

    public static void responseText(HttpServletResponse rsp, String text) {
        Http.responseContent(rsp, text, "text/plain", "UTF-8");
    }

    public static void responseContent(HttpServletResponse rsp, String content, String contentType, String characterEncoding) {
        if (content == null) {
            return;
        }
        try {
            rsp.setHeader("Content-Type", contentType + "; charset=" + characterEncoding);
            rsp.setCharacterEncoding(characterEncoding);
            PrintWriter writer = rsp.getWriter();
            writer.write(content);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> dealReqParams(Map<String, String[]> requestParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            for (String key : requestParams.keySet()) {
                String[] values = requestParams.get(key);
                String valueStr = "";
                for (int i = 0; i < values.length; ++i) {
                    valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
                }
                valueStr = new String(valueStr.getBytes("ISO-8859-1"), "gbk");
                params.put(key, valueStr);
            }
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570\u5904\u7406\u51fa\u9519", e);
        }
    }

    public static String dealRequestBody(HttpServletRequest req, String charsetName) {
        String string;
        DataInputStream dis = null;
        try {
            int bytes;
            int formDataLength = req.getContentLength();
            dis = new DataInputStream((InputStream)req.getInputStream());
            byte[] buff = new byte[formDataLength];
            for (int totalBytes = 0; totalBytes < formDataLength; totalBytes += bytes) {
                bytes = dis.read(buff, totalBytes, formDataLength);
            }
            string = new String(buff, charsetName);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closer.closeQuietly(dis);
                throw throwable;
            }
        }
        Closer.closeQuietly((Object)dis);
        return string;
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static void error(HttpServletResponse response, int statusCode, Throwable ex) {
        response.setStatus(statusCode);
        String message = ex.getMessage();
        Http.responseText(response, message != null ? message : ex.toString());
    }

    public static void error(HttpServletResponse response, int statusCode, String message) {
        response.setStatus(statusCode);
        Http.responseText(response, message);
    }
}

