/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.utils.net;

import com.github.bingoohuang.utils.codec.Json;
import com.github.bingoohuang.utils.net.Url;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReq {
    private final String baseUrl;
    private String req;
    private StringBuilder params = new StringBuilder();
    Logger logger = LoggerFactory.getLogger(HttpReq.class);
    private List<Pair<String, String>> props = Lists.newArrayList();
    private String body;
    private String anchor;

    public HttpReq(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static HttpReq get(String baseUrl) {
        return new HttpReq(baseUrl);
    }

    public HttpReq req(String req) {
        this.req = req;
        return this;
    }

    public HttpReq body(String body) {
        this.body = body;
        return this;
    }

    public HttpReq anchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public HttpReq cookie(String value) {
        if (value == null) {
            return this;
        }
        return this.prop("Cookie", value);
    }

    public HttpReq prop(String name, String value) {
        this.props.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
        return this;
    }

    public HttpReq param(String name, String value) {
        if (this.params.length() > 0) {
            this.params.append('&');
        }
        this.params.append(name).append('=').append(Url.encode(value));
        return this;
    }

    public HttpReq requestBody(String requestBody) {
        if (requestBody != null) {
            if (this.params.length() > 0) {
                this.params.append('&');
            }
            this.params.append(requestBody);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post() {
        HttpURLConnection http = null;
        try {
            String url = this.baseUrl + (this.req == null ? "" : this.req) + (this.params.length() > 0 && this.body != null ? "?" + this.params : "") + (this.anchor == null ? "" : "#" + this.anchor);
            http = this.commonSettings(url);
            this.setHeaders(http);
            this.postSettings(http);
            http.connect();
            this.writePostRequestBody(http);
            String string = this.parseResponse(http, url);
            return string;
        }
        catch (Exception e) {
            this.logger.error("post error {}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private void postSettings(HttpURLConnection http) throws ProtocolException {
        http.setDoOutput(true);
        http.setDoInput(true);
        http.setRequestMethod("POST");
        http.setUseCaches(false);
        http.setInstanceFollowRedirects(true);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        HttpURLConnection http = null;
        try {
            String url = this.baseUrl + (this.req == null ? "" : this.req) + (this.params.length() > 0 ? "?" + this.params : "") + (this.anchor == null ? "" : "#" + this.anchor);
            http = this.commonSettings(url);
            this.setHeaders(http);
            http.connect();
            String string = this.parseResponse(http, url);
            return string;
        }
        catch (Exception e) {
            this.logger.error("get error {}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private void setHeaders(HttpURLConnection http) {
        for (Pair<String, String> prop : this.props) {
            http.setRequestProperty((String)prop.getKey(), (String)prop.getValue());
        }
    }

    private HttpURLConnection commonSettings(String url) throws IOException {
        HttpURLConnection http = (HttpURLConnection)new URL(url).openConnection();
        http.setRequestProperty("Accept-Charset", "UTF-8");
        HttpURLConnection.setFollowRedirects(true);
        http.setConnectTimeout(60000);
        http.setReadTimeout(60000);
        return http;
    }

    private void writePostRequestBody(HttpURLConnection http) throws IOException {
        if (this.params.length() == 0 && StringUtils.isEmpty((CharSequence)this.body)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.body)) {
            OutputStreamWriter out = new OutputStreamWriter(http.getOutputStream(), "UTF-8");
            out.append(this.body);
            out.flush();
            out.close();
        } else {
            DataOutputStream out = new DataOutputStream(http.getOutputStream());
            String postData = this.params.toString();
            out.writeBytes(postData);
            out.flush();
            out.close();
        }
    }

    private String parseResponse(HttpURLConnection http, String url) throws IOException {
        int status = http.getResponseCode();
        String charset = HttpReq.getCharset(http.getHeaderField("Content-Type"));
        if (status == 200) {
            return HttpReq.readResponseBody(http, charset);
        }
        this.logger.warn("non 200 response :" + this.readErrorResponseBody(url, http, status, charset));
        return null;
    }

    private String readErrorResponseBody(String url, HttpURLConnection http, int status, String charset) throws IOException {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = HttpReq.toString(charset, errorStream);
            return url + ", STATUS CODE =" + status + ", headers=" + Json.json(http.getHeaderFields()) + "\n\n" + error;
        }
        return url + ", STATUS CODE =" + status + ", headers=" + Json.json(http.getHeaderFields());
    }

    private static String readResponseBody(HttpURLConnection http, String charset) throws IOException {
        InputStream inputStream = http.getInputStream();
        return HttpReq.toString(charset, inputStream);
    }

    private static String toString(String charset, InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray(), charset);
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return "UTF-8";
        }
        String charset = null;
        for (String param : contentType.replace(" ", "").split(";")) {
            if (!param.startsWith("charset=")) continue;
            charset = param.split("=", 2)[1];
            break;
        }
        return charset == null ? "UTF-8" : charset;
    }
}

